<?php

namespace App\Models;

use App\Services\TransactionService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model
{
   use HasFactory, SoftDeletes;
   use TransactionService;

   /**
    * The database table used by the model.
    *
    * @var string
    */
   protected $table = 'transactions';

   /**
    * Attributes that should be mass-assignable.
    *
    * @var array
    */
   protected $fillable = [
      'type',
      'status',
      'source_amount',
      'source_old_balance',
      'source_new_balance',
      'destination_amount',
      'destination_old_balance',
      'destination_new_balance',
      'exchange_rate',
      'transaction_reference',
      'payment_gateway',

      'external_account_source_id',
      'external_account_destination_id',
      'source_wallet_id',
      'source_currency_id',
      'destination_wallet_id',
      'destination_currency_id',
      'transaction_parent_id',
      'escrow_id',
   ];

   /**
    * The attributes excluded from the model's JSON form.
    *
    * @var array
    */
   protected $hidden = [
      'external_account_source_id',
      'external_account_destination_id',
      'source_wallet_id',
      'source_currency_id',
      'destination_wallet_id',
      'destination_currency_id',
      'transaction_parent_id',
      'order_id',
   ];

   /**
    * The attributes that should be casted to native types.
    *
    * @var array
    */
   protected $casts = [];

   /**
    * The attributes that should be mutated to dates.
    *
    * @var array
    */
   protected $dates = ['created_at', 'updated_at', 'deleted_at'];

   /**
    * The "booting" method of the model.
    *
    * @return void
    */
   public static function boot()
   {
      parent::boot();
   }

   /** Attributes used outside the class to create modify the resource */

   /** Relations */

   public function sourceWallet(): \Illuminate\Database\Eloquent\Relations\belongsTo
   {
      return $this->belongsTo(Wallet::class, "source_wallet_id");
   }

   public function destinationWallet(): \Illuminate\Database\Eloquent\Relations\belongsTo
   {
      return $this->belongsTo(Wallet::class, "destination_wallet_id");
   }

   public function sourceCurrency(): \Illuminate\Database\Eloquent\Relations\belongsTo
   {
      return $this->belongsTo(Currency::class, "source_currency_id");
   }

   public function destinationCurrency(): \Illuminate\Database\Eloquent\Relations\belongsTo
   {
      return $this->belongsTo(Currency::class, "destination_currency_id");
   }

   public function externalSourceAccount(): \Illuminate\Database\Eloquent\Relations\belongsTo
   {
      return $this->belongsTo(ExternalAccount::class, "external_account_source_id");
   }

   public function externalDepositAccount(): \Illuminate\Database\Eloquent\Relations\BelongsTo
   {
      return $this->belongsTo(ExternalAccount::class, "external_account_destination_id");
   }
}
