<?php

namespace App\Models;

use App\Services\PasswordChangeHistoryService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Hash;

class PasswordChangeHistory extends Model
{
    use HasFactory, SoftDeletes;
     use PasswordChangeHistoryService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'password_change_histories';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'old_password',
        'new_password',
        'status',

        'user_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'user_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Check if user new password has already been used
     *
     * @param string $password
     * @return bool
     */
    public function checkIfNewPassedAlreadyUsed(string $password): bool
    {
        return Hash::check($password, $this->{'new_password'});
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */
}
