<?php

namespace App\Models;

use App\Services\OtpVerificationService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OtpVerification extends Model
{
   use HasFactory, SoftDeletes;
   use OtpVerificationService;

   /**
    * The database table used by the model.
    *
    * @var string
    */
   protected $table = 'otp_verifications';

   /**
    * Attributes that should be mass-assignable.
    *
    * @var array
    */
   protected $fillable = [
      'otp',
      'telephone',
      'email',
      'send_at',
      'expired_at',
      'validated_at',
      'otp_attempts_left',

      'user_id',
   ];

   /**
    * The attributes excluded from the model's JSON form.
    *
    * @var array
    */
   protected $hidden = [
      'user_id',
   ];

   /**
    * The attributes that should be casted to native types.
    *
    * @var array
    */
   protected $casts = [
      'send_at' => 'datetime',
      'expired_at' => 'datetime',
      'validated_at' => 'datetime',
   ];

   /**
    * The attributes that should be mutated to dates.
    *
    * @var array
    */
   protected $dates = ['created_at', 'updated_at', 'deleted_at', 'send_at', 'expired_at', 'validated_at'];

   /**
    * The "booting" method of the model.
    *
    * @return void
    */
   public static function boot(): void
   {
      parent::boot();
   }

   /** Attributes used outside the class to create modify the resource */

   /** Relations */

   public function user(): \Illuminate\Database\Eloquent\Relations\BelongsTo
   {
      return $this->belongsTo(User::class);
   }
}
