<?php

namespace App\Models;

use App\Services\OrderDetailAttributeService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderDetailAttribute extends Model
{
    use HasFactory;
    use SoftDeletes;
    use OrderDetailAttributeService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'order_detail_attributes';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'value',
        'extra_value',
        'additional_price',

        'additional_price_currency_id',
        'attribute_id',
        'attribute_value_id',
        'order_detail_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'additional_price_currency_id',
        'attribute_id',
        'attribute_value_id',
        'order_detail_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */

    public function additionalPriceCurrency(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Currency::class, "additional_price_currency_id");
    }

    public function attribute(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Attribute::class, "attribute_id");
    }

    public function attributeValue(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(AttributeValue::class, "attribute_value_id");
    }
}
