<?php

namespace App\Models;

use App\Services\EscrowService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Escrow extends Model
{
    use HasFactory;
    use SoftDeletes;
    use EscrowService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'escrows';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'status',
        'customer_amount',
        'supplier_amount',

        'customer_currency_id',
        'supplier_currency_id',
        'source_wallet_id',
        'destination_wallet_id',
        'order_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'customer_currency_id',
        'supplier_currency_id',
        'source_wallet_id',
        'destination_wallet_id',
        'order_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */
    public function transaction(): \Illuminate\Database\Eloquent\Relations\HasOne
    {
        return $this->hasOne(Transaction::class);
    }

}
