<?php

namespace App\Models;

use App\Services\ChatService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Arr;

class Chat extends Model
{
    use HasFactory, SoftDeletes;
    use ChatService;

   static string $prefixDir = "chat_";

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'chats';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'uuid',
        'name',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();
    }

    /** Attributes used outside the class to create modify the resource */

   public static function reverseChatName(string $name): string
   {
      $names = explode("___", $name);

      return Arr::join(array_reverse($names), "___");
   }

    /** Relations */

    public function participants(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(RealtimeParticipant::class);
    }

    public function latestMessages(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(RealtimeMessage::class)->latest()->limit(30);
    }
}
