<?php

namespace App\Models;

use App\Services\BusinessSubCategoryService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessSubCategory extends Model
{
    use HasFactory, SoftDeletes;
    use BusinessSubCategoryService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'business_sub_categories';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'designation',
        'code',
        'description',

        'business_category_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'business_category_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();

        static::retrieved(function (BusinessSubCategory $businessSubCategory) {
            $businessSubCategory->{'designation'} = __(
                $businessSubCategory->getOriginal('designation')
            );
            $businessSubCategory->{'description'} = __(
                $businessSubCategory->getOriginal('description')
            );
        });
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */

    public function businessSubCategoriesChild(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(BusinessSubCategoryChild::class, 'business_sub_category_id', 'id');
    }
}
