<?php

namespace App\Models;

use App\Services\BusinessCategoryService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessCategory extends Model
{
   use HasFactory, SoftDeletes;
   use BusinessCategoryService;

   /**
    * The database table used by the model.
    *
    * @var string
    */
   protected $table = 'business_categories';

   /**
    * Attributes that should be mass-assignable.
    *
    * @var array
    */
   protected $fillable = [
      'designation',
      'code',
      'description',
      'disabled_at',
   ];

   /**
    * The attributes excluded from the model's JSON form.
    *
    * @var array
    */
   protected $hidden = [];

   /**
    * The attributes that should be casted to native types.
    *
    * @var array
    */
   protected $casts = [
      'disabled_at' => 'timestamp'
   ];

   /**
    * The attributes that should be mutated to dates.
    *
    * @var array
    */
   protected $dates = ['created_at', 'updated_at', 'deleted_at', 'disabled_at'];

   /**
    * The "booting" method of the model.
    *
    * @return void
    */
   public static function boot(): void
   {
      parent::boot();

      static::retrieved(function (BusinessCategory $businessCategory) {
         $businessCategory->{'designation'} = __(
            $businessCategory->getOriginal('designation')
         );
         $businessCategory->{'description'} = __(
            $businessCategory->getOriginal('description')
         );
      });
   }

   /** Attributes used outside the class to create modify the resource */

   /** Relations */

   public function businessSubCategories(): \Illuminate\Database\Eloquent\Relations\HasMany
   {
      return $this->hasMany(BusinessSubCategory::class);
   }
}
