<?php

namespace App\Models;

use App\Services\AccountPrivacySettingService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccountPrivacySetting extends Model
{
   use HasFactory;
   use SoftDeletes;
   use AccountPrivacySettingService;

   /**
    * The database table used by the model.
    *
    * @var string
    */
   protected $table = 'account_privacy_settings';

   /**
    * Attributes that should be mass-assignable.
    *
    * @var array
    */
   protected $fillable = [
      'enable_privacy',
      'enable_2factor_auth',
      'who_can_comment',
      'who_can_mention',
      'who_can_see_follower_list',
      'who_can_invite_you_by_direct_message',
      'who_can_invite_you_into_community',
      'who_can_download_post',

      'user_id',
   ];

   /**
    * The attributes excluded from the model's JSON form.
    *
    * @var array
    */
   protected $hidden = [
      'user_id',
   ];

   /**
    * The attributes that should be casted to native types.
    *
    * @var array
    */
   protected $casts = [];

   /**
    * The attributes that should be mutated to dates.
    *
    * @var array
    */
   protected $dates = ['created_at', 'updated_at', 'deleted_at'];

   /**
    * The "booting" method of the model.
    *
    * @return void
    */
   public static function boot()
   {
      parent::boot();
   }

   /** Attributes used outside the class to create modify the resource */

   /** Relations */
}
