<?php

namespace App\Models;

use App\Services\AccountNotificationSettingService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccountNotificationSetting extends Model
{
    use HasFactory;
    use SoftDeletes;
    use AccountNotificationSettingService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'account_notification_settings';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'enable_push_notification',
        'new_orders',
        'likes',
        'comments',
        'shares',
        'reviews',
        'direct_messages',
        'post_from_subscribed_accounts',
        'live_stream_from_subscribed_accounts',
        'disputes',
        'deposits',
        'withdrawals',
        'transfers',
        'new_subscribers',
        'post_mentions',

        'user_id'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = ['user_id'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */

}
