<?php

namespace App\Listeners;

use App\Events\TwoFactorAuthCodeEvent;
use App\Mail\TwoFactorAuthCode;
use App\Models\OtpVerification;
use Illuminate\Mail\Mailer;

 class TwoFactorAuthCodeListener
{
   /**
    * Create the event listener.
    */
   public function __construct(private readonly Mailer $mailer)
   {
      //
   }

   /**
    * Handle the event.
    */
   public function handle(TwoFactorAuthCodeEvent $event): void
   {
      // Store ...
      OtpVerification::createOrUpdate($event->code, null, $event->email, $event->user);

      try {
         $this->mailer->send(new TwoFactorAuthCode(
            $event->email,
            $event->code,
         ));
      } catch (\Exception $exception) {
         log_debug(
            exception: $exception,
            prefix: 'TwoFactorAuthCodeListener::handle -- Unable to send 2 factor auth code to ::' . $event->email
         );
      }
   }
}
