<?php

namespace App\Listeners;

use App\Events\TelephoneVerificationEvent;
use App\Libs\Sms\Sms;
use App\Models\OtpVerification;

class TelephoneVerificationListener
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(TelephoneVerificationEvent $event): void
    {
        // Store ...
        OtpVerification::createOrUpdate($event->otp, $event->telephone, null);

        (new Sms(
            array($event->telephone),
            __('messages.otp_sms_content', [
                'code' => $event->otp,
                'appName' => config('app.name')
            ])
        ))->send();
    }
}
