<?php

namespace App\Libs\Upload;

use App\Enums\DocumentTypeEnum;
use App\Models\Post;
use App\Models\PostAttachment;
use Illuminate\Http\UploadedFile;

class UploadPostAttachments
{
   /**
    * Upload all post attachments
    *
    * @param UploadedFile $uploadedFile
    * @param Post $post
    * @return string|null
    */
   public static function uploadAttachments(Post $post, UploadedFile $uploadedFile): ?string
   {
      $basePath = sprintf(config('torryme.paths.docs'), $post->buildAttachmentDir());

      $resultPath = upload_file_system(
         DocumentTypeEnum::postAttachment->value,
         $basePath,
         $uploadedFile,
      );

      if (filled($resultPath)) {
         PostAttachment::store(array(
            'path' => $resultPath,
            'type' => upload_file_type($uploadedFile),
            'post_id' => $post->{'id'}
         ));

         // Update post ...
         $post->updateService([
            'completed_at' => now()
         ]);
      }

      return $resultPath;
   }
}
