<?php

namespace App\Libs\Upload;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Http\UploadedFile;
use Pion\Laravel\ChunkUpload\Exceptions\UploadFailedException;
use Pion\Laravel\ChunkUpload\Exceptions\UploadMissingFileException;
use Pion\Laravel\ChunkUpload\Handler\HandlerFactory;
use Pion\Laravel\ChunkUpload\Receiver\FileReceiver;

class ChunkUploadManager
{
    protected FileReceiver $receiver;

    /**
     * Default constructor
     *
     * @param string $requestKey
     */
    public function __construct(
        protected string $requestKey,
    ) {}

    /**
     * Upload file using chunk mode
     *
     * @param Request $request
     * @return UploadedFile|null
     * @throws UploadFailedException
     * @throws UploadMissingFileException
     */
    public function upload(Request $request): UploadedFile|null
    {
        try {
            $this->receiver = new FileReceiver(
                $this->requestKey,
                $request,
                HandlerFactory::classFromRequest($request)
            );

            // Check if the upload is success, throw exception or return response you need
            if ($this->receiver->isUploaded() === false) {
                throw new UploadMissingFileException();
            }

            $save = $this->receiver->receive();

            // File uploading is complete / all chunks are uploaded
            if ($save->isFinished()) {
                return $save->getFile();
            }

            // We are in chunk mode, lets send the current progress
            $save->handler();
        } catch (Exception $exception) {
            log_debug(exception: $exception,  prefix: 'UploadChunkManager::upload');
            throw $exception;
        }

        return null;
    }
}
