<?php

namespace App\Libs\Sms;

class Sms
{
    /**
     * Sms constructor.
     *
     * @param array $phoneNumbers
     * @param string $message
     */
    public function __construct(
        protected array $phoneNumbers,
        protected string $message,
    ) {}

    /**
     * Send sms message
     *
     * @return $this|null
     */
    public function send(): static|null
    {
        if ($this->useAvlyProvider()) {
            return $this;
        }

        // Use another provider ....
        return null;
    }

    /**
     * Use LMT Provider to send message
     *
     * @return bool
     */
    public function useLmtProvider(): bool
    {
        $provider = new LmtProvider($this->phoneNumbers, $this->message);

        return $provider->send();
    }

    /**
     * Use LMT Provider to send message
     *
     * @return bool
     */
    public function useAvlyProvider(): bool
    {
        $provider = new AvlyProvider($this->phoneNumbers, $this->message);

        return $provider->send();
    }
}
