<?php

namespace App\Libs\Sms;

use App\Libs\HttpGuzzle\HttpGuzzle;
use Exception;
use GuzzleHttp\Exception\GuzzleException;

class LmtProvider extends SmsProvider
{
    /**
     * Default constructor.
     *
     * @param array $phoneNumbers
     * @param string $message
     */
    public function __construct(
        protected array $phoneNumbers,
        protected string $message,
    ) {
        parent::__construct($phoneNumbers, $message);
    }

    /**
     * Send message
     *
     * @return bool
     */
    public function send(): bool
    {
        $phoneNumber = preg_replace("/\+/", "", $this->phoneNumbers[0]);
        $baseUrl = config('torryme.api_tokens.lmt_provider.url');

        $http = new HttpGuzzle($baseUrl);

        try {
            $response = $http->post(
                "",
                array(
                    "api_key" => config('torryme.api_tokens.lmt_provider.api_key'),
                    "password" => config('torryme.api_tokens.lmt_provider.password'),
                    "sender" => config('torryme.api_tokens.lmt_provider.sender_id'),
                    "flag" => "long_sms",
                    "message" => $this->message,
                    "phone" => $phoneNumber,
                ),
                array(
                    'headers' => [
                        'Accept' => 'application/json',
                    ]
                )
            );

            if ($response->succeed()) {
                $response = $response->responseData();
                if(array_key_exists("status", $response) && $response['status'] === "success") {
                    return true;
                }

                log_debug(null, "LmtProvider::send -- LMT BULK SMS:: Unable to send sms to " . $phoneNumber . " " . json_encode($response));
            }
        } catch (Exception|GuzzleException $exception) {
            log_debug($exception, "LmtProvider::send -- LMT BULK SMS:: Unable to send sms to " . $phoneNumber);
        }

        return false;
    }
}
