<?php

namespace App\Libs\HttpGuzzle;

use Psr\Http\Message\ResponseInterface;

class HttpGuzzleResponse
{
    /**
     * Default contructor
     *
     * HttpGuzzleResponse constructor.
     * @param ResponseInterface $response
     */
    public function __construct(protected ResponseInterface $response) {}

    /**
     * Get response
     *
     * @return ResponseInterface
     */
    public function getResponse(): ResponseInterface
    {
        return $this->response;
    }

    /** Other functions */

    /**
     * Success ??
     *
     * @return bool
     */
    public function succeed(): bool
    {
        return $this->response->getStatusCode() === 200;
    }

    /**
     * Build response data
     *
     * @return mixed
     */
    public function responseData(): mixed
    {
        if($this->succeed()) {
            try {
                $result = (string) $this->response->getBody();

                return json_decode($result, true);
            } catch (\Exception $exception) {
                log_debug($exception, 'HttpGuzzleResponse::responseData');
            }
        }

        return null;
    }
}
