<?php

namespace App\Libs\HttpGuzzle;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;

class HttpGuzzle
{
    protected Client $httpClient;

    /**
     * Default constructor
     *
     * HttpGuzzle constructor.
     * @param string $baseUrl
     */
    public function __construct(protected string $baseUrl)
    {
        $this->httpClient = new Client([
            'base_uri' => $baseUrl,
            'timeout' => 30.0, // 30 seconds
        ]);
    }

    /**
     * Get request
     *
     * @param string $url
     * @param array $options
     * @return HttpGuzzleResponse
     * @throws GuzzleException
     */
    public function get(string $url, array $options = []): HttpGuzzleResponse
    {
        return new HttpGuzzleResponse($this->httpClient->get($url, $options));
    }

    /**
     * Post request
     *
     * @param string $url
     * @param array $formParams
     * @param array $options
     * @return HttpGuzzleResponse
     * @throws GuzzleException
     */
    public function post(string $url, array $formParams = [], array $options = []): HttpGuzzleResponse
    {
        if(! empty($formParams)) {
            $options["form_params"] = $formParams;
        }

        return new HttpGuzzleResponse($this->httpClient->post($url, $options));
    }
}
