<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class UtcTimeZone
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure(Request): (Response)  $next
     * @return Response
     */
    public function handle(Request $request, Closure $next): Response
    {
        $timeZoneKey = config('torryme.constants.time_zone_key');

        if(filled($timeZoneKey) && filled($request->header($timeZoneKey))) {
            $request->merge([
                $timeZoneKey => $request->header($timeZoneKey)
            ]);
        }

        return $next($request);
    }
}
