<?php

namespace App\Http\Middleware;

use App\Models\User;
use Closure;
use Illuminate\Http\Request;

class Localization
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next): mixed
    {
        $defaultLocale = config('torryme.locales_keys.en');
        $lang = $request->get('lang') ;

        /** @var User $user */
        $user = auth()->user();

        if(! filled($lang) && $user !== null) {
            // Change app language ...
            app()->setLocale($user->{'language_code'} ?? $defaultLocale);
        } else if(array_key_exists($lang, config('torryme.locales_keys'))){
            // Change app language ...
            app()->setLocale($lang);
        }

        if($user !== null && filled($lang)) {
            $user->updateService(array(
                "language_code" => $lang
            ));
        }

        return $next($request);
    }
}
