<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\SeriesSeason;
use App\RequestRules\Api\SeriesSeasonRequestRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class SeriesSeasonController extends Controller
{
    /**
     * Get season episodes
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function episodes(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(SeriesSeasonRequestRules::getepisodes($request->merge(["seasonId" => $request->route("seasonId")])));
        try {
            /** @var SeriesSeason $seriesSeason */
            $seriesSeason = SeriesSeason::findById($request->get('seasonId'));

            $episodeArray = array();
            foreach ($seriesSeason->{"seasonEpisodes"} as $episode) {
                $episodeArray[] = $episode;
            }

            return api_response(100, "Okay", $episodeArray);
        } catch (\Exception $exception) {
            log_debug($exception, "SeriesSeasonController::episodes");
        }

        return api_response(120, __("errors.unknown_error"));
    }


}
