<?php

namespace App\Http\Controllers\Api\Platform;

use App\Exceptions\InvalidProfileSharingAttempt;
use App\Http\Controllers\Controller;
use App\Models\ProfileSharing;
use App\RequestRules\Api\ProfileSharingRequestRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ProfileSharingController extends Controller
{

    /**
     * Profile sharing
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function profileSharing(Request $request): Response|Application|ResponseFactory
    {
        try {
            $sharedProfiles = ProfileSharing::profileSharing($request->get("page"));
            return api_response(100, 'Ok', $sharedProfiles);
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'ProfileSharingController::profileSharing');
        }

        return api_response(101, __('errors.unknown_error'));
    }

    /**
     * Add profile sharing
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function add(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ProfileSharingRequestRules::add());

        try {
            ProfileSharing::addProfileSharing($request->get("recipient_user_id"));

            return api_response(100, 'Ok');
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'ProfileSharingController::add');

            if($exception instanceof InvalidProfileSharingAttempt) {
                return api_response(120, $exception->getMessage());
            }
        }

        return api_response(101, __('errors.unknown_error'));
    }
}
