<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\Currency;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Response;

class CurrencyController extends Controller
{
    /**
     * Get all raw countries
     *
     * @return Application|ResponseFactory|Response
     */
    public function supportedCurrencies(): Response|Application|ResponseFactory
    {
        try {
            $currencies = Currency::allCurrencies();

            return api_response(100, 'Ok', $currencies);
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'CurrencyController::supportedCurrencies');
        }

        return api_response(101, __('errors.unknown_error'));
    }
}
