<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\Country;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Response;
use Illuminate\Support\Collection;
use libphonenumber\PhoneNumberUtil;
use Giggsey\Locale\Locale;
use PragmaRX\Countries\Package\Countries;
use PragmaRX\Countries\Package\Services\Config;

class CountryController extends Controller
{
    /**
     * Get all raw countries
     *
     * @return Application|ResponseFactory|Response
     */
    public function rawCountries(): Response|Application|ResponseFactory
    {
       $platformCountries = Country::allCountries();
       $platformCountries = $platformCountries->pluck('country_code')->toArray();

        $rawCountries = new Collection();
        $phoneUtil = PhoneNumberUtil::getInstance();
        $countriesConfig = new Countries(new Config([]));

        foreach ($phoneUtil->getSupportedRegions() as $countryCode) {
           if(in_array( mb_strtoupper($countryCode), $platformCountries)) {
              $countryCode = strtoupper($countryCode);
              $nativeCountry = $countriesConfig->where('cca2', mb_strtoupper($countryCode))->first();

              $country = new Country();
              $country->{'designation'} = Locale::getDisplayRegion(
                 sprintf('-%s', $countryCode),
                 app()->getLocale()
              );
              $country->{'dial_code'} = '+' . $phoneUtil->getCountryCodeForRegion($countryCode);
              $country->{'country_code'} = strtoupper($countryCode);
              $country->{'native_designation'} = $nativeCountry?->get('name')?->get('native')?->first()?->get('common');

              $rawCountries[] = $country;
           }
        }

        $rawCountries = $rawCountries->sortBy(function($raw){
            return $raw->{'designation'};
        })->toArray();

        return api_response(100, 'Ok', array_values($rawCountries));
    }
}
