<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\BusinessSubCategory;
use Exception;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Response;

class BusinessSubCategoryController extends Controller
{
    /**
     * Get all business sub categories
     *
     * @return Application|ResponseFactory|Response
     */
    public function allInterests(): Response|Application|ResponseFactory
    {
        try {
            $result = collect();
            $businessSubCategories = BusinessSubCategory::getBusinessSubCategories();

            $randSample = $businessSubCategories->random(25)->values();
            $ranDomIds = $randSample->pluck('id')->values()->toArray();
            foreach ($businessSubCategories as $item) {
                if(! in_array($item->{'id'}, $ranDomIds)) {
                    $result->add($item);
                }
            }

            return api_response(100, 'Okay', array(
                'interests' => $result,
                'samples' => $randSample
            ));
        } catch (Exception $exception) {
            log_debug(exception: $exception, prefix: 'BusinessSubCategoryController::getBusinessSubCategories');
        }

        return api_response(103, __('errors.unknown_error'));
    }

    /**
     * Get business sub categories by business category
     *
     * @return Application|ResponseFactory|Response
     */
    public function getByCategory(): Response|Application|ResponseFactory
    {
        $businessSubCategories = BusinessSubCategory::getByBusinessCategory();

        if($businessSubCategories == null) {
            return api_response(120, __('errors.unknown_error'));
        }

        return api_response(100, "Okay", $businessSubCategories);
    }
}
