<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\Attribute;
use App\Models\User;
use App\RequestRules\Api\AttributeRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;


class AttributeController extends Controller
{
    /**
     * Get business attributes
     *
     * @return Application|ResponseFactory|Response
     */
    public function getBusinessAttributes(): Response|Application|ResponseFactory
    {
        /** @var User $user */
        $user = auth()->user();

        $business = $user->{"business"};
        $allAttributes = Attribute::getBusinessAttributes($business);

        if($allAttributes == null) {
            return api_response(120, __('errors.unknown_error'));
        }

        return api_response(100, "Okay", $allAttributes);
    }

    /**
     * Get base attributes
     *
     * @return Application|ResponseFactory|Response
     */
    public function getBaseAttributes(): Response|Application|ResponseFactory
    {
        $attributes = Attribute::getBaseAttributes();

        if($attributes == null) {
            return api_response(120, __('errors.unknown_error'));
        }

        return api_response(100, "Okay", $attributes);
    }

    /**
     * Create custom attribute
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function createCustomAttribute(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(AttributeRules::create());
        $data = $request->all();

        $result = Attribute::createCustomAttribute($data);

        if($result == null) {
            return api_response(120, __('errors.unknown_error'));
        }

        return api_response(100, "Okay", $result);
    }
}
