<?php

namespace App\Http\Controllers\Api\Auth;

use Ably\AblyRest;
use Ably\Exceptions\AblyException;
use Ably\Models\TokenRequest;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class AblyController extends AuthenticateController
{
    /**
     * Create token request for ably authentication
     *
     * @param Request $request
     * @return mixed|null
     */
    public function createTokenRequest(Request $request): mixed
    {
        $tokenParams = $request->all();
        $ablyClient = new AblyRest(env('ABLY_KEY'));

        try {
            $tokenRequest = $ablyClient->auth->createTokenRequest($tokenParams);

            return api_response(100, "Okay", $tokenRequest->toArray());
        } catch (AblyException $exception) {
            log_debug($exception, "AblyController::createTokenRequest Unable to create token request");
        }

        return api_response(101, "Error");
    }
}
