<?php

namespace App\Events;

use App\Enums\ChannelEnum;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SendDisputeInvitationEvent implements ShouldBroadcast
{
   use Dispatchable, InteractsWithSockets, SerializesModels;

   /**
    * NewMessageSent constructor.
    *
    * @param array $dispute
    */
   public function __construct(private readonly array $dispute)
   {
   }

   /**
    * Get the channels the event should broadcast on.
    *
    * @return PrivateChannel
    */
   public function broadcastOn(): PrivateChannel
   {
      // Build broadcast channel ...
      $channel = sprintf(
         ChannelEnum::ioDisputeChannel->{'value'},
         $this->dispute['uuid'],
      );
      log_debug(null, "Try to send broadcast for new dispute invitation into " . $channel);

      return new PrivateChannel($channel);
   }

   /**
    * Broadcast's event name
    *
    * @return string
    */
   public function broadcastAs(): string
   {
      return ChannelEnum::disputeInvitationEvent->{'value'};
   }

   /**
    * Data sending back to client
    *
    * @return array
    */
   public function broadcastWith(): array
   {
      return $this->dispute;
   }

   /**
    * The name of the queue on which to place the broadcasting job.
    */
   public function broadcastQueue(): string
   {
      return 'dispute';
   }
}
