<?php

namespace App\Concerns;

use App\Events\DeliveryRealtimeMessageEvent;
use App\Events\ReadRealtimeMessageEvent;
use App\Events\SendRealtimeMessageEvent;

trait RealtimeMessageBroadcastConcern
{
    /**
     * Broadcasting of new message
     *
     * @return void
     */
    public function broadcastMessage(): void
    {
        $message = $this;

        broadcast(new SendRealtimeMessageEvent(
           $message->serializeForChannel()
        ))->toOthers();
    }

   /**
    * Message delivery
    *
    * @return void
    */
   public function delivery(): void
   {
      $message = $this;

      broadcast(new DeliveryRealtimeMessageEvent(
         $message->serializeForChannel()
      ))->toOthers();
   }

   /**
    * Mark message as read
    *
    * @return void
    */
   public function seen(): void
   {
      $message = $this;

      broadcast(new ReadRealtimeMessageEvent(
         $message->serializeForChannel()
      ))->toOthers();
   }
}
