<?php

namespace App\Concerns;

use App\Events\SendDisputeMessageEvent;

trait DisputeMessageBroadcastConcern
{
   /**
    * Broadcasting of new message
    *
    * @return void
    */
   public function broadcastMessage(): void
   {
      $message = $this;

      broadcast(new SendDisputeMessageEvent(
         $message->serializeForChannel(),
      ))->toOthers();
   }
}
