# Installing


* [Requirements](#requirements)
* [Step 1: Get the code](#step1)
* [Step 2: Use Composer to install dependencies](#step2)
* [Step 3: Create database](#step3)
* [Step 4: Install](#step4)
* [Troubleshooting](#troubleshooting)

<a name="requirements"></a>
## Requirements

* PHP ^8.1
* MySQL server

<a name="step1"></a>
## Step 1: Get the code

    git clone https://gitlab.com/Bureau-X/torryme-backend.git
    cd torryme-backend

<a name="step2"></a>
## Step 2: Install dependencies with Composer

    composer install

<a name="step3"></a>
## Step 3: Create the Database

Once you finished the first two steps, you can create the *MySQL* database server. You must create the database with `utf-8` collation (`utf8_general_ci`), for the application to work.  As admin login to *MySQL* database and then execute the following:

    CREATE DATABASE torryme_dev
    CREATE USER 'torryme_dev'@'localhost' IDENTIFIED BY '<password>';
    GRANT ALL PRIVILEGES ON torryme_dev.* TO 'torryme_dev'@'localhost';

<a name="step4"></a>
## Step 4: Configure the Environment

**Copy** the **.env.example** file to **.env**

    cp .env.example .env

**Edit** the `.env` file and set the database configuration among the other settings.

Set database information

    DB_DATABASE=torryme_dev
    DB_USERNAME=torryme_dev
    DB_PASSWORD=<password>

Clear configuration cache

     php artisan config:cache

Regenerate Composer's autoloader using the *dump-autoload* command

    composer dump-autoload

Set the application key

    php artisan key:generate

**Create** new schema in your database.  **Note**: make sure that your run *php artisan config:cache* and *composer dump-autoload* prior to executing any migration or seed steps

    php artisan migrate

**Populate** the database. **Note**: run seed only if you have not migrated old data from the previous step.

    php artisan db:seed

And we are ready to go.  Run server:

    php artisan config:cache
    php artisan storage:link
    php artisan serve

**To change the port address**, run the following command:

    php artisan serve --port=8080 // For port 8080

**Type** on web browser:

    http://localhost:[port]/

Congrats! You have the running server

<a name="troubleshooting"></a>
## Troubleshooting
### Memory limit errors

Composer may sometimes fail on some commands with this message:

    PHP Fatal error: Allowed memory size of XXXXXX bytes exhausted <...>

Try increasing the limit in your php.ini file (ex. */etc/php5/cli/php.ini* for Debian-like systems):

    ; Use -1 for unlimited or define an explicit value like 2G
    memory_limit = -1

Composer also respects a memory limit defined by the COMPOSER_MEMORY_LIMIT environment variable:

    export COMPOSER_MEMORY_LIMIT=-1
    composer <...>

### Memory limit errors

'mix' n’est pas reconnu en tant que commande interne

    npm install laravel-mix@latest --save-dev
