define("mod_threesixo/question_bank",["exports","core/templates","core/notification","core/ajax","core/str","core/modal_factory","core/modal_events","core/pending","mod_threesixo/events","core/checkbox-toggleall"],(function(_exports,templates,notification,ajax,_str,_modal_factory,_modal_events,_pending,_events,CheckboxToggleAll){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}
/**
   * AMD code for the Question Bank.
   *
   * The question bank dialogue contains all the questions that can be added to the 360 feedback activity.
   * It also serves as the interface where questions can be added, edited, or even removed permanently from the question bank.
   *
   * @module     mod_threesixo/question_bank
   * @class      question_bank
   * @copyright  2016 Jun Pataleta <jun@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,templates=_interopRequireWildcard(templates),notification=_interopRequireWildcard(notification),ajax=_interopRequireWildcard(ajax),_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events),_pending=_interopRequireDefault(_pending),CheckboxToggleAll=_interopRequireWildcard(CheckboxToggleAll);const SELECTORS_PICK_ALL="#pick-all",SELECTORS_ADD_QUESTION="#btn-question-bank-add",SELECTORS_QUESTION_CHECKBOX=".question-checkbox",SELECTORS_DELETE_QUESTION=".delete-question-button",SELECTORS_EDIT_QUESTION=".edit-question-button";let selectedQuestionsOld,selectedQuestions,threeSixtyId,questionTypes,questions=[];function checkQuestions(questions){for(const i in questions){const question=questions[i];-1!==selectedQuestions.indexOf(questions[i].id)&&(question.checked=!0)}return questions}const displayInputDialogue=function(threesixtyId,questionId){(0,_str.get_string)("addanewquestion","mod_threesixo").then((function(title){const data={threesixtyid:threesixtyId};if(questionId){data.questionid=questionId;for(const i in questions){const question=questions[i];if(question.id===questionId){data.question=question.question,data.type=question.type;break}}}data.questionTypes=function(selectedId){const questionTypeOptions=[];for(const key in questionTypes){if(!questionTypes.hasOwnProperty(key))continue;const questionType={typeVal:key,typeName:questionTypes[key]};void 0!==selectedId&&key===selectedId&&(questionType.selected=!0),questionTypeOptions.push(questionType)}return questionTypeOptions}(data.type);return function(dialogueTitle,bodyTemplate){const pendingPromise=new _pending.default("mod_threesixo/question_input");_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:dialogueTitle,body:bodyTemplate,large:!0}).then((function(modal){return modal.show(),modal.getRoot().on(_modal_events.default.bodyRendered,(function(){const questionInput=document.getElementById("question-input");questionInput&&questionInput.focus()})),modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal.getRoot().on(_modal_events.default.save,(()=>{const questionInput=document.getElementById("question-input"),question=questionInput.value.trim();if(!question)return question.value="",questionInput.form.classList.add("was-validated"),questionInput.classList.add("is-invalid"),questionInput.focus(),!1;const data={question:question,type:document.getElementById("question-type-select").value,threesixtyid:document.getElementById("threesixtyid").value};let method="mod_threesixo_add_question";const questionId=document.getElementById("question-id").value;return questionId&&(method="mod_threesixo_update_question",data.id=questionId),ajax.call([{methodname:method,args:data}])[0].then((function(){return refreshQuestionsList()})).catch(notification.exception)})),!0})).then((()=>pendingPromise.resolve())).catch(notification.exception)}(title,templates.render("mod_threesixo/item_edit",data))})).catch(notification.exception)};const updateItemSelection=(questionId,isSelected)=>{if(isSelected){-1===selectedQuestions.indexOf(questionId)&&selectedQuestions.push(questionId)}else{const index=selectedQuestions.indexOf(questionId);index>-1&&selectedQuestions.splice(index,1)}},registerEvents=function(){document.addEventListener("click",(e=>{if(e.target.closest(SELECTORS_PICK_ALL)){document.querySelectorAll(SELECTORS_QUESTION_CHECKBOX).forEach((checkbox=>{const questionId=parseInt(checkbox.dataset.questionid);updateItemSelection(questionId,checkbox.checked)}))}else if(e.target.closest(SELECTORS_QUESTION_CHECKBOX)){const questionCheckbox=e.target.closest(SELECTORS_QUESTION_CHECKBOX),questionId=parseInt(questionCheckbox.dataset.questionid);updateItemSelection(questionId,questionCheckbox.checked)}else if(e.target.closest(SELECTORS_EDIT_QUESTION)){e.preventDefault();const editQuestionButton=e.target.closest(SELECTORS_EDIT_QUESTION),threesixtyId=parseInt(editQuestionButton.dataset.threesixtyid),questionId=parseInt(editQuestionButton.dataset.questionid);displayInputDialogue(threesixtyId,questionId)}else if(e.target.closest(SELECTORS_DELETE_QUESTION)){e.preventDefault();const deleteButton=e.target.closest(SELECTORS_DELETE_QUESTION),threesixtyId=deleteButton.dataset.threesixtyid;!function(questionId,threesixtyId){(0,_str.get_string)("deletequestion","mod_threesixo").then((function(title){return _modal_factory.default.create({title:title,body:(0,_str.get_string)("confirmquestiondeletion","mod_threesixo"),type:_modal_factory.default.types.SAVE_CANCEL})})).then((function(modal){return modal.getRoot().on(_modal_events.default.save,(function(){ajax.call([{methodname:"mod_threesixo_delete_question",args:{id:questionId,threesixtyid:threesixtyId}}])[0].then((function(){return refreshQuestionsList()})).catch(notification.exception)})),modal.getRoot().on(_modal_events.default.hidden,(()=>{modal.destroy()})),modal.show()})).catch(notification.exception)}(deleteButton.dataset.questionid,threesixtyId)}else if(e.target.closest(SELECTORS_ADD_QUESTION)){e.preventDefault();const id=e.target.closest(SELECTORS_ADD_QUESTION).dataset.threesixtyid;displayInputDialogue(id,null)}}))};function refreshQuestionsList(){ajax.call([{methodname:"mod_threesixo_get_questions",args:{}}])[0].then((response=>{questions=response.questions;const data={pickerMode:threeSixtyId,questions:checkQuestions(questions)};return templates.render("mod_threesixo/question_list",data)})).then((compiledSource=>{const questionListWrapper=document.querySelector("#questionListWrapper");return questionListWrapper&&(questionListWrapper.innerHTML=compiledSource),null})).catch(notification.exception)}function renderQuestionBank(){const context={pickerMode:threeSixtyId};ajax.call([{methodname:"mod_threesixo_get_questions",args:{}}])[0].then((function(response){return questions=response.questions,context.questions=checkQuestions(questions),templates.render("mod_threesixo/question_bank",context)})).then((questionBankTemplate=>(0,_str.get_string)("labelpickfromquestionbank","mod_threesixo").then((title=>function(title,questionBankTemplate){const pendingPromise=new _pending.default("mod_threesixo/question_bank");_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:title,body:questionBankTemplate,large:!0}).then((function(modal){const modalRoot=modal.getRoot();return modalRoot.on(_modal_events.default.hidden,(function(){modal.destroy()})),modalRoot.on(_modal_events.default.save,(function(){let changed=!1;if(selectedQuestionsOld.forEach((questionId=>{-1===selectedQuestions.indexOf(questionId)&&(changed=!0)})),changed||selectedQuestions.forEach((questionId=>{-1===selectedQuestionsOld.indexOf(questionId)&&(changed=!0)})),changed){const data={threesixtyid:threeSixtyId,questionids:selectedQuestions};ajax.call([{methodname:"mod_threesixo_set_items",args:data}])[0].then((function(){return(0,_events.notifyItemsUpdated)(threeSixtyId)})).catch(notification.exception)}else(0,_events.notifyItemsUpdated)(threeSixtyId)})),modal.show()})).then((()=>pendingPromise.resolve())).catch(notification.exception)}(title,questionBankTemplate))))).then((()=>(threeSixtyId&&CheckboxToggleAll.init(),!0))).catch(notification.exception)}var _default={init:function(id){threeSixtyId=id;const methodCalls=[{methodname:"mod_threesixo_get_question_types",args:{}}];threeSixtyId&&methodCalls.push({methodname:"mod_threesixo_get_items",args:{threesixtyid:threeSixtyId}});const promises=ajax.call(methodCalls);promises[0].then((function(response){return questionTypes=response.questiontypes,threeSixtyId?promises[1]:(renderQuestionBank(),null)})).then((response=>{if(null===response)return!1;selectedQuestions=[],selectedQuestionsOld=[];const items=response.items;for(const i in items)items.hasOwnProperty(i)&&(selectedQuestions.push(items[i].questionid),selectedQuestionsOld.push(items[i].questionid));return renderQuestionBank(),!0})).catch(notification.exception),registerEvents()}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=question_bank.min.js.map