define("mod_threesixo/events",["exports","core/event_dispatcher"],(function(_exports,_event_dispatcher){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.notifyItemsUpdated=_exports.eventTypes=void 0;
/**
   * Javascript events for the `mod_threesixo`.
   *
   * @module     mod_threesixo/events
   * @copyright  2023 Jun Pataleta <jun@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   *
   * @example <caption>Example of listening to a mod_threesixo event.</caption>
   * import {eventTypes as threesixoEventTypes} from 'core_threesixo/events';
   *
   * document.addEventListener(threesixoEventTypes.itemsUpdated, e => {
   *     window.console.log(e.target); // The HTMLElement relating to the block whose content was updated.
   *     window.console.log(e.detail.instanceId); // The instanceId of the block that was updated.
   * });
   */
const eventTypes={itemsUpdated:"mod_threesixo/itemsUpdated"};_exports.eventTypes=eventTypes;_exports.notifyItemsUpdated=threesixtyId=>(0,_event_dispatcher.dispatchEvent)(eventTypes.itemsUpdated,{threesixtyId:threesixtyId})}));

//# sourceMappingURL=events.min.js.map