<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'choice', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   choice
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['addmorechoices'] = 'Add more choices';
$string['allowupdate'] = 'Allow choice to be updated';
$string['answered'] = 'Answered';
$string['completionsubmit'] = 'Show as complete when user makes a choice';
$string['completiondetail:submit'] = 'Choose a group';
$string['defaultsettings'] = 'Default settings';
$string['displayhorizontal'] = 'Display horizontally';
$string['displaymode'] = 'Display mode';
$string['displayvertical'] = 'Display vertically';
$string['expired'] = 'Sorry, this activity closed on {$a} and is no longer available';
$string['fillinatleastoneoption'] = 'You need to provide at least one possible answer.';
$string['fillinatleasttwooptions'] = 'You need to provide at least two possible answers.';
$string['full'] = '(Full)';
$string['havetologin'] = 'You have to log in before you can submit your choice';
$string['choice'] = 'Choice';
$string['choicegroupclose'] = 'Until';
$string['choicegroup:deleteresponses'] = 'Delete responses';
$string['choicegroup:downloadresponses'] = 'Download responses';
$string['choicegroupfull'] = 'This group choice is full and there are no available places.';
$string['choicegroup:choose'] = 'Record a choice';
$string['choicegroupname'] = 'Group choice name';
$string['choicegroupopen'] = 'Open';
$string['choicegroupoptions'] = 'Choice options';
$string['choicegroupoptions_help'] = 'Here is where you specify which groups participants can choose from.

The list on the left displays all available groups and groupings. To add one or several groups, select these from the list and click "Add". To add all groups from a grouping, select the grouping and click "Add".

The selected groups appear on the list on the right.

To remove any groups from the selection, select them from the list on the right and click "Remove".';
$string['limitanswers_help'] = 'This option allows you to limit the number of participants that can select each choice option. When the limit is reached then no-one else can select that option.

If limits are disabled then any number of participants can select each of the options.';
$string['choicegroup:addinstance'] = 'Add a new group choice activity';
$string['choicegroup:readresponses'] = 'Read responses';
$string['choicegroupsaved'] = 'Your choice has been saved';
$string['choicetext'] = 'Choice text';
$string['chooseaction'] = 'Choose an action ...';
$string['choosegroup'] = 'Choose a group';
$string['createdate'] = 'Group creation date';
$string['limit'] = 'Limit';
$string['limitanswers'] = 'Limit the number of responses allowed';
$string['modulename'] = 'Group choice';
$string['modulename_help'] = 'The Group Choice module allows students to enrol themselves in a group within a course. The teacher can select which groups students can choose from and the maximum number of students allowed in each group.';
$string['modulename_link'] = 'mod/choicegroup/view';
$string['modulenameplural'] = 'Group choices';
$string['mustchooseone'] = 'You must choose an answer before saving.  Nothing was saved.';
$string['noguestchoose'] = 'Sorry, guests are not allowed to make choices.';
$string['noresultsviewable'] = 'The results are not currently viewable.';
$string['neverresultsviewable'] = 'The results are not viewable.';
$string['name'] = 'Name';
$string['afterresultsviewable'] = 'The results will be visible after you have made your choice.';
$string['notyetresultsviewable'] = 'The results will be visible after this activity has closed.';
$string['notanswered'] = 'Not answered yet';
$string['notenrolledchoose'] = 'Sorry, only enrolled users are allowed to make choices.';
$string['notopenyet'] = 'Sorry, this activity is not available until {$a}';
$string['onlyactive'] = 'Filter out response data for users with expired or suspended enrolments';
$string['option'] = 'Group';
$string['pluginadministration'] = 'Choice administration';
$string['pluginname'] = 'Group choice';
$string['privacy'] = 'Privacy of results';
$string['publish'] = 'Publish results';
$string['publishafteranswer'] = 'Show results to students after they answer';
$string['publishafterclose'] = 'Show results to students only after the choice is closed';
$string['publishalways'] = 'Always show results to students';
$string['publishanonymous'] = 'Publish anonymous results, do not show student names';
$string['publishnames'] = 'Publish full results, showing names and their choices';
$string['publishnot'] = 'Do not publish results to students';
$string['removemychoicegroup'] = 'Remove my choice';
$string['removeresponses'] = 'Remove all responses';
$string['responses'] = 'Responses';
$string['responsesto'] = 'Responses to {$a}';
$string['savemychoicegroup'] = 'Save my choice';
$string['showunanswered'] = 'Show column for unanswered';
$string['spaceleft'] = 'space available';
$string['spacesleft'] = 'spaces available';
$string['systemdefault_date'] = 'System Default (currently Group creation date)';
$string['systemdefault_name'] = 'System Default (currently Name)';
$string['taken'] = 'Taken';
$string['timerestrict'] = 'Restrict answering to this time period';
$string['viewallresponses'] = 'View {$a} responses';
$string['byparticipants'] = 'by {$a} participants';
$string['withselected'] = 'With selected';
$string['yourselection'] = 'Your selection';
$string['skipresultgraph'] = 'Skip result graph';
$string['sortgroupsby'] = 'Sort groups by';
$string['moveselectedusersto'] = 'Move selected users to...';
$string['numberofuser'] = 'The number of users';
$string['groupdoesntexist'] = 'Some of the specified groups don\'t exist within this course. The teacher should create the necessary groups and/or modify this activity.';
$string['samegroupused'] = 'The same group can not be used several times.';

$string['members/max'] = 'Members / Capacity';
$string['members/'] = 'Members';
$string['groupmembers'] = 'Group members';
$string['page-mod-choice-x'] = 'Any Group choice module page';
$string['showdescription'] = 'Show descriptions';
$string['hidedescription'] = 'Hide descriptions';
$string['generallimitation'] = 'General limitation';
$string['applytoallgroups'] = 'Apply to all groups';
$string['pleasesetgroups'] = 'Please create at least one group in this course.';
$string['nogroupincourse'] = 'No groups defined in course.';
$string['pleasesetonegroupor'] = 'Please create at least one group in this course.<br /><br />
<ul>
<li><a href="{$a->linkgroups}">manage course groups</a></li>
<li><a href="{$a->linkcourse}">get back to the course</a></li>
</ul>';
$string['pleaseselectonegroup'] = 'Please select at least one group to choose from.';

$string['multipleenrollmentspossible'] = 'Allow enrollment to multiple groups';
$string['and'] = 'and';
$string['event:answered'] = 'Choice made';
$string['event:answered_desc'] = 'The user with id \'{$a->userid}\' has chosen a group in the group choice with the course module id \'{$a->contextinstanceid}\'.';
$string['event:removed'] = 'Choice removed';
$string['event:removed_desc'] = 'The user with id \'{$a->userid}\' has removed his choice in the group choice with the course module id \'{$a->contextinstanceid}\'.';
$string['event:reportviewed'] = 'Report viewed';
$string['event:reportviewed_desc'] = 'The user with id \'{$a->userid}\' has viewed the report for the group choice activity with the course module id \'{$a->contextinstanceid}\'.';
$string['groupsheader'] = "Groups";
$string['the_value_you_entered_is_not_a_number'] = "The value you entered is not a number.";
$string['add_groupings'] = "Add Groupings";
$string['add_grouping'] = "Add Grouping";
$string['add_groups'] = "Add Groups";
$string['del_groups'] = "Remove Groups";
$string['del_group'] = "Remove Group";
$string['add_group'] = "Add Group";
$string['add'] = "Add";
$string['del'] = "Remove";
$string['set_limit_for_group'] = "Limit For ";
$string['available_groups'] = 'Available Groups';
$string['selected_groups'] = 'Selected Groups';
$string['char_bullet_collapsed'] = '►';
$string['char_bullet_expanded'] = '▼';
$string['char_limitui_parenthesis_start'] = '⦗';
$string['char_limitui_parenthesis_end'] = '⦘';
$string['expand_all_groupings'] = 'Expand All Groupings';
$string['collapse_all_groupings'] = 'Collapse All Groupings';
$string['double_click_grouping_legend'] = 'Double click on a grouping to expand/collapse individually.';
$string['double_click_group_legend'] = 'Double click on a group to add it.';
$string['privacy:metadata'] = 'The Group Choice plugin does not store any personal data. All user data is stored by the group component of Moodle core (core_group).';
$string['showgroupmembers'] = 'Show Group Members';
$string['hidegroupmembers'] = 'Hide Group Members';
$string['activitydate:willopen'] = 'Opens:';
$string['activitydate:hasopened'] = 'Opened:';
$string['activitydate:willclose'] = 'Closes:';
$string['activitydate:exceeded'] = 'Due date exceeded.';
$string['activitydate:notavailableyet'] = 'Not available yet.';
$string['activitydate:closingbeforeopening'] = 'Opening date must be earlier than closing date.';
$string['mustchoosemax'] = 'You must choose a maximum of {$a} groups. Nothing was saved.';
$string['maxenrollments'] = 'Max. enrollments';
$string['maxenrollments_help'] = 'This option allows to limit the number of group enrollments for a participant. Use default value **0** if there is no limit.';

