<?php
// This file is part of Exabis Eportfolio (extension for Moodle)
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
// (c) 2016 GTN - Global Training Network GmbH <office@gtn-solutions.com>.

return [
        'translation:language' => [
                'German',
                'English',
        ],
        'translation:person' => [
                'Andreas Riepl',
                'Andreas Riepl',
        ],
        'translation:organisation' => [
                'IZ Steyr',
                'IZ Steyr',
        ],
        'translation:email' => [
                'ariepl.work@gmail.com',
                'ariepl.work@gmail.com',
        ],

        // === Main ===
        // Shown in admin plugin list.
        'pluginname' => [
                'Exabis ePortfolio',
                'Exabis ePortfolio',
        ],
        // === Shown in block title and all headers.
        'blocktitle' => [
                'Exabis ePortfolio',
                'Exabis ePortfolio',
        ],
        'exaport:use' => [
                'Nutzung',
                'Use allowed',
        ],
        'exaport:addinstance' => [
                'Exabis ePortfolio zum Kurs hinzuf&uumlgen',
                'add Exabis ePortfolio to the course',
        ],
        'exaport:myaddinstance' => [
                'Exabis ePortfolie zur Startseite hinzuf&uumlgen',
                'add Exabis ePortfolio on My home',
        ],
        'exaport:export' => [
                'Export of SCORM-Files',
                'Export of SCORM-Files',
        ],
        'exaport:import' => [
                'Import of SCORM-Files',
                'Import of SCORM-Files',
        ],
        'exaport:importfrommoodle' => [
                'Import from Moodle',
                'Import from Moodle',
        ],
        'exaport:shareintern' => [
                'Internal sharing of views',
                'Internal sharing of views',
        ],
        'exaport:shareextern' => [
                'External sharing of views',
                'External sharing of views',
        ],
        'exaport:allowposts' => [
                'Allow posting',
                'Allow posting',
        ],
        'exaport:competences' => [
                'Allow competences',
                'Allow competences',
        ],
        'exaport:viewartifactsfromstudents' => [
                '',
                'Can see portfolio artifacts of own students',
        ],
        'new' => [
                'Neu',
                'New',
        ],
        'addbookmark' => [
                'Bookmark hinzufügen',
                'Add bookmark',
        ],
        'addcategory' => [
                'Kategorie hinzufügen',
                'Add category',
        ],
        'attachment' => [
                'Anhang',
                'attachment',
        ],
        'attachincluded' => [
                'Anhang?',
                'attachment?',
        ],
        'awaiting' => [
                '(\\$a wartend)',
                '($a awaiting)',
        ],
        'back' => [
                'zurück',
                'Back',
        ],
        'close' => [
            'Schließen',
            'close',
        ],
        'backtocourse' => [
                'zurück zum Kurs',
                'Back to course',
        ],
        'categories' => [
                'Kategorien',
                'Categories',
        ],
        'explaincategories' => [
                '<span class=\'block_eportfolio_bold\'>Kategorien:</span> hier können Sie die Kategorien einsehen und bearbeiten.',
                'Categories: here you can create and modify categories',
        ],
        'category' => [
                'Kategorie',
                'Category',
        ],
        'categoryhead' => [
                'Bezeichnung der Kategorie',
                'Category name',
        ],
        'categorysaved' => [
                'Kategorie hinzugefügt.',
                'Category added.',
        ],
        'categoryedited' => [
                'Kategorie gespeichert.',
                'Category saved.',
        ],
        'categorydeleted' => [
                'Kategorie gel&ouml;scht.',
                'Category deleted.',
        ],
        'date' => [
                'Datum',
                'Date',
        ],
        'dontincludeurl' => [
                'Diese Option ausw&auml;hlen um die Verknüpfung zwischen Bookmark und URL aufzuheben',
                'Check this box to unassociate the bookmark with the URL',
        ],
        'duplicatedurl' => [
                'Diese URL ist bereits bei den Bookmarks vorhanden.',
                'You already have this URL bookmarked.',
        ],
        'editcategories' => [
                'Kategorien bearbeiten',
                'edit categories',
        ],
        'explaining' => [
                'Das ePortfolio-System kann verwendet werden um Webadressen, Dateien, Notizen und Kommentare zu verwalten.',
                'The Portfolio may be used to store web addresses, files, as well as enter notes that may contain insights or little notes the user may wish to write down.',
        ],
        'explaininglink' => [
                '<span class=\'block_eportfolio_bold\'>Externe Links:</span> diese Links k&ouml;nnen mit anderen KursteilnehmerInnen ausgetauscht werden.',
                'Links.  These links may be shared with all authorized course members.',
        ],
        'explainingfile' => [
                '<span class=\'block_eportfolio_bold\'>Dateien:</span> diese Dateien k&ouml;nnen mit anderen KursteilnehmerInnen ausgetauscht werden.',
                'Files. These files may be shared with all authorized course members.',
        ],
        'explainingnote' => [
                '<span class=\'block_eportfolio_bold\'>Notizen:</span> diese Notizen k&ouml;nnen mit anderen KursteilnehmerInnen ausgetauscht werden.',
                'Notes. These notes may be shared with all authorized course members.',
        ],
        'explainingshare' => [
                'Um einem/einer anderen TeilnehmerIn den Link zu ver&ouml;ffentlichen, klicken Sie auf den jeweiligen Namen und speichern Sie dann die &Auml;nderungen.  Sie k&ouml;nnen mehr als eine/n TeilnehmerIn ausw&auml;hlen.',
                'To allow a participant to see the link, click on their name and then click on Save Changes. You can choose more than one participant.',
        ],
        'explainingshared' => [
                'Folgende TeilnehmerInnen haben ver&ouml;ffentlichte Links, Dateien bzw. Notizen.',
                'These participants have shared some of their external links, files or notes.',
        ],
        'explainingsharefile' => [
                'Um einem/einer anderen TeilnehmerIn die Datei zu ver&ouml;ffentlichen, klicken Sie auf den jeweiligen Namen und speichern Sie dann die &Auml;nderungen.  Sie k&ouml;nnen mehr als eine/n TeilnehmerIn ausw&auml;hlen.',
                'To allow a participant to see the file, click on their name and then click on Save Changes.  You can choose more than one participant.',
        ],
        'explainingsharenote' => [
                'Um einem/einer anderen TeilnehmerIn die Notiz zu ver&ouml;ffentlichen, klicken Sie auf den jeweiligen Namen und speichern Sie dann die &Auml;nderungen.  Sie k&ouml;nnen mehr als eine/n TeilnehmerIn ausw&auml;hlen.',
                'To allow a participant to see the note, click on their name and then click on Save Changes.  You can choose more than one participant.',
        ],
        'file' => [
                'Datei',
                'File',
        ],
        'iconfile' => [
                null,
                'Icon picture',
        ],
        'iconfile_merge' => [
                'Symbol mit Ordner-Symbol kombinieren',
                'Merge this icon picture with the folder icon',
        ],
        'iconfile_merge_description' => [
                'Symbolbild verknüpft sich mit dem Ordner-Symbol.',
                'Icon picture will try (without any guarantee) to merge with standard folder icon. The icon will be replaced with the new image.',
        ],
        'firstnameshared' => [
                'Familienname',
                'First Name',
        ],
        'go' => [
                'Go!',
                'Go!',
        ],
        'hidesummary' => [
                '(Gesamtaufstellung ausblenden)',
                '(hide summary)',
        ],
        'managecategories' => [
                'Kategorien verwalten',
                'Manage categories',
        ],
        'mandatoryfields' => [
                'Eine Kategorienbezeichnung und eine kurze Beschreibung ist erforderlich. Bitte füllen Sie beides aus.',
                'The field\'s name, category and intro are required. Please fill them in.',
        ],
        'mandatoryfieldsforcat' => [
                'Eine Feldbezeichnung ist erforderlich. Bitte füllen Sie diese aus.',
                'The field name is required. Please fill them in.',
        ],
        'myportfolio' => [
                'Meine Portfolio Artefakte',
                'My Portfolio Artifacts',
        ],
        'myportfoliotitle' => [
                'ePortfolio-Modul: Fügen Sie hier Links und Dateien hinzu.',
                'Exabis ePortfolio module: Add your links and files here.',
        ],
        'newlink' => [
                'Neuen externen Link hinzufügen',
                'Add new link',
        ],
        'newfile' => [
                'Neue Datei hinzufügen',
                'Add new file',
        ],
        'newnote' => [
                'Neue Notiz hinzufügen',
                'Add new note',
        ],
        'nocategories' => [
                '(bisher gibt es noch keine Kategorien)',
                '(no categories yet)',
        ],
        'nobookmarksall' => [
                '(bisher gibt es noch keine Eintr&auml;ge)',
                '(no items yet)',
        ],
        'nobookmarkslink' => [
                '(bisher gibt es noch keine Links)',
                '(no links yet)',
        ],
        'nobookmarksfile' => [
                '(bisher gibt es noch keine Dateien)',
                '(no files yet)',
        ],
        'nobookmarksnote' => [
                '(bisher gibt es noch keine Notizen)',
                '(no notes yet)',
        ],
        'noentry' => [
                'Kein Eintrag',
                'No entry',
        ],
        'note' => [
                'Notiz',
                'Note',
        ],
        'notetitle' => [
                'Notiz',
                'Note',
        ],
        'shared_views' => [
                'Geteilte Views',
                'Shared Views',
        ],
        'showall' => [
                'auch andere Kurse anzeigen',
                'Show Other Courses Too',
        ],
        'showcourse' => [
                'nur diesen Kurs anzeigen',
                'Show This Course Only',
        ],
        'showsummary' => [
                '(Gesamtaufstellung einblenden)',
                '(show summary)',
        ],
        'strshare' => [
                'Ver&ouml;ffentlichen',
                'Share',
        ],
        'strunshare' => [
                'Ver&ouml;ffentlichung zurücknehmen',
                'Unshare',
        ],
        'summary' => [
                'Gesamtaufstellung (optional)',
                'Summary (optional)',
        ],
        'url' => [
                'URL',
                'URL',
        ],
        'maincategory' => [
                'Hauptkategorie',
                'Main category',
        ],
        'subcategory' => [
                'Unterkategorie',
                'Sub category',
        ],
        'accessoptions' => [
                'Wer hat Zugriff?',
                'Who has access?',
        ],
        'shareallexceptthose' => [
                'Zugriff für <span class=\'block_eportfolio_bold\'>alle</span> (auch jene, die hier nicht angezeigt werden) au&szlig;er folgenden Benutzern',
                'Access for <span class=\'block_eportfolio_bold\'>all</span> (even those who aren\'t listed here) except the following users',
        ],
        'sharenoneexceptthose' => [
                'Zugriff für <span class=\'block_eportfolio_bold\'>keine</span> au&szlig;er folgende Benutzer',
                'Access for <span class=\'block_eportfolio_bold\'>nobody</span> except the following users',
        ],
        'internalaccessall' => [
                'Zugriff für <span class=\'block_eportfolio_bold\'>alle</span>',
                'Access for <span class=\'block_eportfolio_bold\'>all</span>',
        ],
        'internalaccessusers' => [
                'Zugriff nur für folgende Benutzer',
                'Access only for the following users',
        ],
        'internalaccessgroups' => [
                'Zugriff für folgende Gruppen',
                'Access only for the following groups',
        ],
        'externaccess' => [
                'externer ePortfolio-Link',
                'external ePortfolio-Link',
        ],
        'emailaccess' => [
                'Per Email teilen',
                'Share by Email',
        ],
        'emailaccessdescription' => [
                'Geben Sie eine Email Adresse pro Zeile ein<br />Jede Adresse erhält einen eindeutigen Link mit Zugriff auf diese View. Das Löschen der Adresse löscht den Zugriff auf diese Veiw.',
                'Input an email address per line<br />Each email will receive a unique link with access to this view. Deleting the email will remove access to this view.',
        ],
        'emailaccessmessagesubject' => [
                'Eine View wurde mit dir geteilt',
                'New shared View for you',
        ],
        'emailaccessmessage' => [
                'Hallo! {$a->sendername} hat eine die View "{$a->viewname}" mit dir geteilt. Sie kann hier abgerufen werden: {$a->url}',
                'Hello! {$a->sendername} has shared the view "{$a->viewname}" for you. You can view it here: {$a->url}',
        ],
        'emailaccessmessageHTML' => [
                'Hallo!<br />{$a->sendername} hat eine die View "{$a->viewname}" mit dir geteilt.<br />Sie ist kann <a href="{$a->url}">hier</a> aberufen werden',
                'Hello!<br />{$a->sendername} has shared the view "{$a->viewname}" for you.<br />You can view it <a href="{$a->url}">here</a>.',
        ],
        'showallusers' => [
                'Zeige Benutzer aller meiner Kurse',
                'Show users of all my courses',
        ],
        'showcourseusers' => [
                'Zeige nur Benutzer des aktuellen Kurses',
                'Show only users of the course',
        ],
        'sharedpersons' => [
                'Personen mit ver&ouml;ffentlichten Portfolios',
                'Persons with shared Portfolios',
        ],
        'moodleimport' => [
                'Import aus Moodle-Aufgaben',
                'Import from Moodle-assignments',
        ],
        'nomoodleimportyet' => [
                'Im Moment sind noch keine Abgaben vorhanden!',
                'At the moment you have no submission at any assignment!',
        ],
        'deletecategoryconfirm' => [
                'Wollen Sie die Kategorie "{$a->name}" wirklich l&ouml;schen? Es werden alle Eintr&auml;ge in dieser Kategorie und alle Unterkategorien mitgel&ouml;scht!',
                'Do you really want to delete the category "{$a->name}"? All entries in this category and all subcategories will be deleted!',
        ],
        'name' => [
                'Name',
                'Name',
        ],
        'role' => [
                'Rolle',
                'Role',
        ],
        'nousersfound' => [
                'Keine Benutzer gefunden',
                'No users found',
        ],
        'delete' => [
                'L&ouml;schen',
                'Delete',
        ],
        'add' => [
                'Hinzufügen',
                'Add',
        ],
        'edit' => [
                'Editieren',
                'Edit',
        ],
        'checkall' => [
                'Alle auswählen',
                'Check all',
        ],
        'grouptitle' => [
                'Gruppentitel',
                'Group title',
        ],
        'membercount' => [
                'Anzahl von Mitgliedern',
                'Number of members',
        ],
        'nogroupsfound' => [
                'Keine Gruppen gefunden',
                'No groups found',
        ],
        'make_it_yours' => [
                'Mach\' es zu deinem Eigenen',
                'Make it yours',
        ],

        // === Export/import.
        'import' => [
                'Import SCORM-Datei',
                'Import SCORM-File',
        ],
        'import_short' => [
                'Import',
                'Import',
        ],
        'explainexport' => [
                '<span class=\'block_eportfolio_center\'><span class=\'block_eportfolio_bold\'>Export:</span> hier k&ouml;nnen Sie Ihr ePortfolio exportieren</span>',
                'Export your portfolio here.',
        ],
        'createexport' => [
                'SCORM-Datei erstellen',
                'Create SCORM-File',
        ],
        'clicktodownloadscorm' => [
                'Folgenden Button drücken, um SCORM-Datei herunterzuladen:',
                'Press button to download the SCORM file:',
        ],
        'add_directory_structure' => [
                'Mit Unterverzeichnissen exportieren',
                'Add directory-structure',
        ],
        'download' => [
                'Herunterladen',
                'Download',
        ],
        'endedit' => [
                'Editieren beenden',
                'End editing',
        ],
        'change' => [
                '&auml;ndern',
                'Change',
        ],
        'explainpersonal' => [
                '<span class=\'block_eportfolio_bold\'>Pers&ouml;nliche Informationen</span>',
                'Personal information',
        ],
        'personal' => [
                'Informationen',
                'Information',
        ],
        'descriptionsaved' => [
                'Beschreibung gespeichert',
                'description saved',
        ],
        'course' => [
                'Kurs',
                'Course',
        ],
        'importexport' => [
                'Import/Export',
                'Import/Export',
        ],
        'explainimport' => [
                'hier k&ouml;nnen Sie SCORM-Dateien ins Portfolio importieren. Wenn Marker gefunden werden, die darauf hinweisen, dass diese SCORM-Datei zuvor aus dem Portfolio-Modul exportiert wurde, so wird versucht, die Stuktur entsprechend zu importieren.',
                'Here you can import a SCORM-File into the portfolio. If markers from previous exports are found the import tries to import the data in the existing filestructure.',
        ],
        'makeimport' => [
                'Import',
                'Import',
        ],
        'add_this_file' => [
                'Diese Datei hinzufügen',
                'add this file',
        ],
        'bookmarksall' => [
                'Alle Eintr&auml;ge',
                'All Items',
        ],
        'bookmarkslinks' => [
                'Links',
                'Links',
        ],
        'bookmarksfiles' => [
                'Dateien',
                'Files',
        ],
        'bookmarksnotes' => [
                'Notizen',
                'Notes',
        ],
        'noguestpost' => [
                'G&auml;ste haben hier keinen Zugriff!',
                'Guests don\'t have access here!',
        ],
        'comments' => [
                'Kommentare',
                'Comments',
        ],
        'addcomment' => [
                'Kommentar hinzufügen',
                'Add comment',
        ],
        'externcomment' => [
                'Kommentare mitver&ouml;ffentlichen',
                'Share comments in external portfolio',
        ],
        'itemgrading' => [
                'Beurteilung',
                'Grading',
        ],
        'gradeitem' => [
                'Abgabe beurteilen',
                'Grade the item',
        ],
        'submititem' => [
                'Abgeben',
                'Submit',
        ],
        'saveitem' => [
                'Speichern',
                'Save',
        ],

        // === Notes.
        'deletenoteconfirm' => [
                'Wollen Sie diese Notiz wirklich l&ouml;schen?',
                'Do you really want to delete this note?',
        ],
        'deletelinkconfirm' => [
                'Wollen Sie diesen Link wirklich l&ouml;schen?',
                'Do you really want to delete this link?',
        ],
        'deletefileconfirm' => [
                'Wollen Sie diese Datei wirklich l&ouml;schen?',
                'Do you really want to delete this file?',
        ],

        // === Different.
        'couldninsertcomment' => [
                'Kommentar konnte nicht eingefügt werden!',
                'Couldn\'t insert comment!',
        ],
        'importedcommentsstart' => [
                'Importierte Kommentare:<br /><br />',
                'Imported comments:<br /><br />',
        ],
        'importedcommentsend' => [
                'Ende importierte Kommentare',
                'End of imported comments',
        ],
        'filetypenotdetected' => [
                'Filetyp von $a->filename ($a->title) konnte nicht ermittelt werden. Datei wurde nicht importiert!',
                'Filetype of $a->filename ($a->title) could not be detected. File not imported!',
        ],
        'linkedfilenotfound' => [
                'Datei $a->filename in $a->url ($a->title) wurde nicht gefunden. Datei wurde nicht importiert!',
                'File $a->filename in $a->url ($a->title) was not found. File not imported!',
        ],
        'couldntinsert' => [
                'Konnte $a nicht in der Datenbank einfügen',
                'Couldn\'t insert $a into database',
        ],
        'couldntcreatedirectory' => [
                'Verzeichnis konnte nicht erstellt werden',
                'Couldn\'t create directory',
        ],
        'couldntcopyfile' => [
                'Konnte Datei $a nicht kopieren! Datei wurde nicht importiert!',
                'Couldn\'t copy file for $a! File not imported.',
        ],
        'success' => [
                'Datei erfolgreich importiert',
                'File imported successful',
        ],
        'couldntinsertcategory' => [
                'Kategorie konnte nicht eingefügt werden!',
                'Could not insert category!',
        ],
        'couldntupdatecategory' => [
                'Kategorie konnte nicht aktualisiert werden!',
                'Could not update category!',
        ],
        'couldntextractscormfile' => [
                'SCORM-Datei konnte nicht extrahiert werden!',
                'Couldn\'t extract SCORM-file!',
        ],
        'couldntcreatetempdir' => [
                'Tempor&auml;res Verzeichnis konnte nicht erstellt werden.!',
                'Couldn\'t create temporary directory!',
        ],
        'scormhastobezip' => [
                'SCORM-Datei muss im zip-Format vorliegen!',
                'SCORM-File has to be a .zip-File',
        ],
        'uploadfailed' => [
                'Upload nicht erfolgreich!',
                'Upload failed.',
        ],
        'couldntupdatedesc' => [
                'Beschreibung konnte nicht aktualisiert werden!',
                'Could not update your description!',
        ],
        'couldntinsertdesc' => [
                'Beschreibung konnte nicht eingefügt werden!',
                'Could not insert the description!',
        ],
        'exportcomment' => [
                'Das ist eine exportierte Datei von exabis ePortfolio. Bitte entfernen Sie die Kommentare nicht, da sie sonst nicht mehr mitimportiert werden k&ouml;nnen!',
                'This is an exported file from Exabis ePortfolio. Please do not remove the comments, they are needed for the import!',
        ],
        'comment' => [
                'Kommentar',
                'Comment',
        ],
        'commentshouldnotbeempty' => [
                'Der Kommentar darf nicht leer sein.',
                'You have to enter a comment.',
        ],
        'title' => [
                'Titel',
                'Title',
        ],
        'titlenotemtpy' => [
                'Der Titel darf nicht leer sein.',
                'You have to enter a title.',
        ],
        'intro' => [
                'Inhalt',
                'Content',
        ],
        'intronotempty' => [
                'Der Inhalt darf nicht leer sein.',
                'You have to enter a content.',
        ],
        'link' => [
                'Link',
                'Link',
        ],
        'categorynotempty' => [
                'Es muss eine Kategorie ausgew&auml;hlt sein.',
                'You have to choose a category.',
        ],
        'urlnotempty' => [
                'Die URL darf nicht leer sein.',
                'You have to enter an URL.',
        ],
        'selectall' => [
                'Alle markieren',
                'Select All',
        ],
        'deselectall' => [
                'Alle Markierungen l&ouml;schen',
                'Deselect All',
        ],
        'internalaccess' => [
                'Interner Zugriff',
                'Internal Access',
        ],
        'externalaccess' => [
                'Externer Zugriff',
                'External Access',
        ],
        'loginasmode' => [
                'Sie haben als Administrator keine Zugriff auf fremde Portfolios',
                'You can\'t access portfolios in \'Login As\'-Mode.',
        ],
        'badsessionkey' => [
                'Session nicht mehr gültig',
                'Bad Session Key',
        ],
        'invalidinstance' => [
                'Ungültige Instanz',
                'That\'s an invalid instance',
        ],
        'invalidcourseid' => [
                'Ungültige Kursnummer',
                'That\'s an invalid course id',
        ],
        'wronglinkid' => [
                'Falsche Link-Id',
                'Wrong link id',
        ],
        'incorrectlinksid' => [
                'Falsche Links-Post Id',
                'Incorrect links post id',
        ],
        'incorrectnoteid' => [
                'Falsche Notizen Id',
                'Incorrect note id',
        ],
        'unknownaction' => [
                'Unbekannte Aktion',
                'Unknown action',
        ],
        'filenotfound' => [
                'Datei nicht gefunden',
                'File not found',
        ],
        'wrongfileid' => [
                'Falsche Datei Id',
                'Wrong file id',
        ],
        'wrongfilepostid' => [
                'Falsche Datei-Post Id',
                'Wrong file id',
        ],
        'wrongnoteid' => [
                'Falsche Notiz Id',
                'Wrong note id',
        ],
        'wrongnotepostid' => [
                'Falsche Notiz-Post Id',
                'Wrong note postbid',
        ],
        'bookmarknotfound' => [
                'Bookmark nicht gefunden',
                'Bookmark not found',
        ],
        'commentnotfound' => [
                'Kommentar nicht gefunden',
                'Comment not found',
        ],
        'updateposterror' => [
                'Posting konnte in Datenbank nicht aktualisiert werden',
                'There was an error updating this post in the database',
        ],
        'deleteposterror' => [
                'Fehler beim L&ouml;schen des Postings',
                'Error occured while deleting post',
        ],
        'addposterror' => [
                'Posting konnte in Datenbank nicht hinzugefügt werden',
                'There was an error adding this post in the database',
        ],
        'invalidassignmentid' => [
                'Falsche Abgabe-Id',
                'Invalid assignment id',
        ],
        'invalidfileatthisassignment' => [
                'Datei existiert nicht zu dieser Abgabe!',
                'File does not exist at this assignment!',
        ],
        'publishedportfolios' => [
                'Ver&ouml;ffentliche Portfolios',
                'Published portfolios',
        ],
        'viewcategories' => [
                'Kategorien verwalten',
                'manage categories',
        ],
        'updownarrow' => [
                'Pfeil nach oben/nach unten',
                'updown arrow',
        ],
        'comment_delete_confirmation' => [
                'Wollen Sie wirklich diesen Kommentar löschen?',
                'Do you really want to delete this comment?',
        ],

        // Shared portfolios.
        'nocoursetogether' => [
                'Kein Kurs',
                'No Course',
        ],
        'nothingshared' => [
                'Kein freigegebenen ePortfolios gefunden',
                'Nobody is sharing a portfolio with you',
        ],

        // === Errors.
        'nouserforid' => [
                'Kein Benutzer zu dieser Id!',
                'User not found (id unknown)',
        ],
        'nouserforaccess' => [
                'Benutzer nicht gefunden (Zugriffscode unbekannt)',
                'User not found (access-code unknown)',
        ],

        // === Export.
        'export' => [
                'Export SCORM-Datei',
                'Export SCORM-File',
        ],
        'export_short' => [
                'Export',
                'Export',
        ],
        'exportepx' => [
                'Export EPX-Datei',
                'Export EPX-File',
        ],
        'createepxexport' => [
                'EPX-Datei erstellen',
                'Create EPX-File',
        ],
        'exportviewselect' => [
                'Um alle Einträge einer bestimmten View zu exportieren, bitte diese hier w&auml;hlen',
                'To export all items of a specific view, please select it here',
        ],
        'export_directory' => [
                'Exportiere Ordnerstruktur',
                'Export Directory-structure',
        ],
        'createexport_directory' => [
                'Erstelle Ordnerstruktur',
                'Create Directory-structure',
        ],

        // === Stuff.
        'type' => [
                'Typ',
                'Type',
        ],
        'share' => [
                'Share',
                'Share',
        ],
        'explainingall' => [
                'Alle Eintr&auml;ge im Portfolio',
                'All Items in your portfolio',
        ],
        'share_to_other_users' => [
                'Benutzer suchen',
                'Search Users',
        ],
        'other_users_course' => [
                'Benutzer, die nicht in meinen Kursen sind',
                'Users not in my courses',
        ],
        'other_groups_course' => [
                'Andere Kurse',
                'Other courses',
        ],

        // === Item sorting.
        'userdefinedsort' => [
                'Eigene Sortierung vornehmen',
                'Define your own search',
        ],
        'movetop' => [
                'An erste Stelle',
                'Move top',
        ],
        'movebottom' => [
                'An letzte Stelle',
                'Move bottom',
        ],

        // === Views.
        'view' => [
                'View',
                'View',
        ],
        'views' => [
                'Meine Views',
                'My Views',
        ],
        'explainingviews' => [
                'View verwalten',
                'Manage your views.',
        ],
        'noviews' => [
                'Bitte Views anlegen',
                'Please create a new View',
        ],
        'viewnotfound' => [
                'Das Objekt ist für den Benutzer nicht einsehbar / Keine Zugriffsberechtigung.',
                'View not found',
        ],
        'newview' => [
                'Neue View erstellen',
                'Add View',
        ],
        'viewinformation' => [
                'View Informationen',
                'View Information',
        ],
        'viewdescription' => [
                'Beschreibung',
                'description',
        ],
        'viewdesign' => [
                'View Darstellung',
                'View Design',
        ],
        'viewitems' => [
                'Deine Eintr&auml;ge',
                'Your Items',
        ],
        'viewitem' => [
                'Eintrag',
                'Item',
        ],
        'view_specialitems' => [
                'Spezielle Eintr&auml;ge',
                'Special Items',
        ],
        'view_specialitem_headline' => [
                'Kopfzeile',
                'Headline',
        ],
        'view_specialitem_personal' => [
                'Persönliche Information',
                'Personal information',
        ],
        'view_specialitem_text' => [
                'Text',
                'Text',
        ],
        'view_specialitem_media' => [
                'Medieneintrag',
                'Media',
        ],
        'view_specialitem_badge' => [
                'Badge',
                'Badge',
        ],
        'view_specialitem_headline_defaulttext' => [
                'Kopfzeile hier eingeben',
                'Enter Headline Here',
        ],
        'view_specialitem_text_defaulttext' => [
                'Text hier eingeben',
                'Enter Text Here',
        ],
        'view_sharing' => [
                'Ver&ouml;ffentlichen',
                'Sharing',
        ],
        'viewand' => [
                'und',
                'and',
        ],
        'view_sharing_noaccess' => [
                'Kein Zugriff',
                'No Access',
        ],
        'show' => [
                'Anzeigen',
                'Show',
        ],
        'thiscourse' => [
                'Aktueller Kurs',
                'This course',
        ],
        'othercourses' => [
                'Andere Kurse',
                'other courses',
        ],
        'autofillview' => [
                'Alle bestehenden Artefakte in diese View einfügen',
                'Automatically add all available artefacts to this view',
        ],
        'sharetoteacher' => [
                'Sofort mit allen Kurs-Trainer/innen teilen',
                'Share to all teachers in this course',
        ],
        'createpage' => [
                'Zieh das Elemente in das Feld unterhalb, um deinen Inhalt zu erstellen.',
                'Drag and drop content blocks from the tabs below to create your page.',
        ],
        'chooselayout' => [
                'W&aumlhle ein Layout für deinen View.',
                'Select how you would like the columns in your page to be laid out.',
        ],
        'viewtitle' => [
                'Titel und Beschreibung',
                'Title and description',
        ],
        'viewcontent' => [
                'Inhalt',
                'Content',
        ],
        'viewlayout' => [
                'Layout',
                'Layout',
        ],
        'viewshare' => [
                'Teilen',
                'Share',
        ],
        'viewlayoutgroup1' => [
                '1 Spalte',
                '1 column',
        ],
        'viewlayoutgroup2' => [
                '2 Spalten',
                '2 columns',
        ],
        'viewlayoutgroup3' => [
                '3 Spalten',
                '3 columns',
        ],
        'viewlayoutgroup4' => [
                '4 Spalten',
                '4 columns',
        ],
        'viewlayoutgroup5' => [
                '5 Spalten',
                '5 columns',
        ],
        'viewlayout1' => [
                'Gleiche Breite',
                'Equal widths',
        ],
        'viewlayout2' => [
                'Gleiche Breite',
                'Equal widths',
        ],
        'viewlayout3' => [
                'Linke Spalte breiter',
                'Larger left column',
        ],
        'viewlayout4' => [
                'Rechte Spalte breiter',
                'Larger right column',
        ],
        'viewlayout5' => [
                'Gleiche Breite',
                'Equal widths',
        ],
        'viewlayout6' => [
                'Mittlere Spalte breiter',
                'Larger centre column',
        ],
        'viewlayout7' => [
                'Mittlere Spalte viel breiter',
                'Much larger centre column',
        ],
        'viewlayout8' => [
                'Gleiche Breite',
                'Equal widths',
        ],
        'viewlayout9' => [
                'Mittlere Spalte breiter',
                'Larger centre columns',
        ],
        'viewlayout10' => [
                'Gleiche Breite',
                'Equal widths',
        ],
        'personalinformation' => [
                'Persönliche Information',
                'Personal Information',
        ],
        'cvinformation' => [
                'Lebenslauf Information',
                'CV Information',
        ],
        'headertext' => [
                'Kopfzeile',
                'Headertext',
        ],
        'item' => [
                'Artefakt',
                'Item',
        ],
        'items' => [
                'Artefakte',
                'Items',
        ],
        'media' => [
                'Medieneintrag',
                'Media',
        ],
        'fieldstoshow' => [
                'Anzuzeigende Felder',
                'Fields to show',
        ],
        'listofartefacts' => [
                'W&aumlhle ein Element aus',
                'List of Artefacts',
        ],
        'listofbadges' => [
                'Liste von Badges',
                'List of Badges',
        ],
        'addButton' => [
                'Hinzufügen',
                'Add',
        ],
        'saveButton' => [
                'Speichern',
                'Save',
        ],
        'cancelButton' => [
                'Abbrechen',
                'Cancel',
        ],
        'blocktitle2' => [
                'Blocktitel',
                'Block title',
        ],
        'blockcontent' => [
                'Blockinhalt',
                'Block content',
        ],
        'firstname' => [
                'Vorname',
                'First name',
        ],
        'lastname' => [
                'Nachname',
                'Last name',
        ],
        'profilepicture' => [
                'Profilbild',
                'Profile picture',
        ],
        'nopicture' => [
                'kein Bild',
                'no picture',
        ],
        'noprofilepicture' => [
                'kein Bild verfügbar',
                'no profile picture available',
        ],
        'mailadress' => [
                'E-Mail-Adresse',
                'Email adress',
        ],
        'nomail' => [
                'keine Mail-Adresse',
                'no email',
        ],
        'noemails' => [
                'keine Mail-Adresse vorhanden',
                'no email adress available',
        ],
        'aboutme' => [
                'Über mich',
                'About me',
        ],
        'notify' => [
                'benachrichtigen',
                'notify',
        ],
        'sharejs' => [
                'teilen',
                'share',
        ],
        'mediacontent' => [
                'URL oder eingebetteter Code*',
                'URL or embed code *',
        ],
        'height' => [
                'H&ouml;he',
                'Height',
        ],
        'width' => [
                'Breite',
                'Width',
        ],
        'media_allowed_notes' => [
                'URLs der folgenden Seiten sind erlaubt:',
                'URLs from the following sites are allowed:',
        ],
        'filterByTag' => [
                'Tag zum Filtern verwenden',
                'Filter by tag',
        ],
        'tagarea_block_exaportitem' => [
                'Meine Portfolio Artefakte',
                'My Portfolio Artifacts',
        ],
        'searchByTitle' => [
                'Suchen',
                'Search',
        ],
        'clearAllFilers' => [
                'Alle Filter zurücksetzen',
                'Clear all filters',
        ],
        'sharedwith' => [
                'Geteilt mit',
                'Shared with',
        ],
        'sharedwith_user_cnt' => [
                'Mit {$a} Benutzern geteilt',
                'Shared with {$a} users',
        ],
        'sharedwith_onlyme' => [
                'Nur mit mir geteilt',
                'Shared only with me',
        ],
        'sharedwith_shareall' => [
                'Mit allen Benutzer:innen geteilt',
                'Shared with all users',
        ],
        'sharedwith_shareexternal' => [
                'Geteilte externe Views',
                'Shared external',
        ],
        'sharedwith_group' => [
                'Mit meiner Gruppe geteilt',
                'Shared with my group',
        ],
        'sharedwith_group_cnt' => [
            'Mit {$a} Gruppe geteilt',
            'Shared with {$a} groups',
        ],

        // === Copy to course.
        'filecopiedtocourse' => [
                'Datei wurde in den Kurs $a->coursename unter dem Namen $a->filename kopiert',
                'File copied to course $a->coursename under the name of $a->filename',
        ],
        'copyitemtocourse' => [
                'In Kurs kopieren',
                'Copy to course',
        ],
        'desp_language' => [
                'Desp Sprache',
                'Desp Language',
        ],
        'cofigureblock' => [
                'Konfigurationsblock',
                'Configure Block',
        ],
        'selectitems' => [
                'W&aumlehle Elemente aus',
                'Select items',
        ],
        'cofigureblock_text' => [
                'Text',
                'Choose text',
        ],
        'cofigureblock_header' => [
                'Konfiguration der Kopfzeile',
                'Choose headline',
        ],
        'cofigureblock_item' => [
                'Auswahl der Artefakte',
                'Choose item',
        ],
        'cofigureblock_media' => [
                'Medieneintrag',
                'Choose media',
        ],
        'cofigureblock_personalinfo' => [
                'Pers&ouml;nliche Information',
                'Choose personal info',
        ],
        'cofigureblock_cvinfo' => [
                'Lebenslauf Information',
                'Choose cv info',
        ],
        'cofigureblock_badge' => [
                'Badges auswählen',
                'Choose Badges',
        ],
        'cofigureblock_cvinfo_education_history' => [
                'Bildungs-Karriere',
                'Education history',
        ],
        'cofigureblock_cvinfo_employment_history' => [
                'Bildungs-Karriere',
                'Employment history',
        ],
        'cofigureblock_cvinfo_certif' => [
                'Zertifikate, Akkreditierungen, Auszeichnungen',
                'certifications, accreditations and awards',
        ],
        'cofigureblock_cvinfo_public' => [
                'Bücher und Publikationen',
                'Books and publications',
        ],
        'cofigureblock_cvinfo_mbrship' => [
                'Mitgliedschaften',
                'Memberships',
        ],
        'cofigureblock_cvinfo_goals' => [
                'Meine Ziele',
                'My goals',
        ],
        'cofigureblock_cvinfo_skills' => [
                'Meine Kompetenzen',
                'My skills',
        ],
        'cofigureblock_cvinfo_interests' => [
                'Interessen',
                'Interests',
        ],
        'in' => [
                'at',
                'at',
        ],
        'cofigureblock_cvinfo_withfiles' => [
                'mit Anhängen publizieren',
                'With attachment files',
        ],

        // === Desp.
        'back_to_desp' => [
                'zurück zum d-ESP',
                'back to language portfolio',
        ],
        'desp_pluginname' => [
                'Dossier',
                'Dossier',
        ],
        'steckbrief' => [
                'Steckbrief',
                'Profile',
        ],
        'desp_categories' => [
                '
    Erzählungen, Rollenspielszenen, Gedichte, Collagen
    Lebenslauf
    Berichte über Theateraufführungen, Ausstellungen
    Berichte über Projekte, Projektreflexionen
    Audio- und Videoclips
    Begegnungen durch Reisen in andere Länder
    Überlegungen zu deinem Sprachenlernen
    Zeugnisse
    Zertifikate
    Bestätigungen
    Hören
    Einzelarbeit
    Partnerarbeit
    Gruppenarbeit
    Lesen
    Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    An Gesprächen teilnehmen
     - Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    Zusammenhängend sprechen
     - Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    Schreiben
     - Einzelarbeit
     - Gruppenarbeit
     - Partnerarbeit
',
                '
    stories, roleplays, essays, collagen
    curriculum vitae
    reviews of theatre productions, exhibitions
    project reports and reflections
    audio- and videoclips
    encounters with other nationalities
    thoughts about your language skills
    report cards
    certificates
    acknowledgements
    listening
     - individual work
     - partner work
     - group work
    reading
     - individual work
     - partner work
     - group work
    participating in conversations
     - individual work
     - partner work
     - group work
    speaking fluently
     - individual work
     - partner work
     - group work
    writing
     - individual work
     - partner work
     - group work
',
        ],

        // === Config.
        'config_feature_copy_to_course' => [
                'Schüler dürfen Dateien in den Kurs kopieren',
                'Allow students to copy ePortfolio files to their courses',
        ],
        'competenceinteraction' => [
                'Interaktion mit Block Exabis Competence Grid, falls dieser installiert ist, zulassen.',
                'Allow interaction with block Exabis Competence Grid, in case it is installed',
        ],
        'opencomps' => [
                'Kompetenzen auswählen',
                'Choose your competences',
        ],
        'selectcomps' => [
                'W&auml;hle hier die Kompetenzen, die zu deinem Upload passen!',
                'Choose competences associated with your upload!',
        ],
        'competences_old_version' => [
                'Auf diesem Moodle ist eine alte Version von Exabis Competences installiert. Diese wird von Exabis Eportfolio nicht mehr unterstützt.',
                'An outdated version of Exabis Competences that is no longer supported by Exabis Eportfolio is installed on this moodle.',
        ],
        'expandcomps' => [
                'Alle &ouml;ffnen',
                'Expand all',
        ],
        'contactcomps' => [
                'Alle schlie&szlig;en',
                'Contract all',
        ],
        'studentcomps' => [
                'Hier kannst du einsch&auml;tzen, ob folgende Kompetenzen durch Dein Artefakt erreicht wurden.',
                'Here you can self-assess whether you have acquired the competency with your artefact.',
        ],
        'teachercomps' => [
                'Hier k&ouml;nnen Sie beurteilen, ob der Schüler folgende Kompetenzen durch sein Artefakt erreicht hat.',
                'Here you can assess whether your students have acquired the competency with this artefact.',
        ],
        'competences' => [
                'Kompetenzen',
                'competences',
        ],
        'desp_einleitung' => [
                'Hier ist nun meine Sammelmappe, mein Dossier. Hier kann ich anderen zeigen, was ich alles gemacht habe. Ich kann genau sehen, wie viel ich schon gelernt habe.',
                'Here is your portfolio. You can show others what you have accomplished by yourself.',
        ],
        'settings_interaktion_exacomp_head' => [
                'Interaktion exabis ePortfolio - Exabis Competence Grid',
                'Interaction exabis ePortfolio - Exabis Competence Grid',
        ],
        'settings_interaktion_exacomp_body' => [
                'Interaktion mit Block Exabis Competence Grid, falls dieser installiert ist, zulassen.',
                'Interaction with block Exabis Competence Grid, in case it is installed',
        ],
        'settings_allow_loginas_head' => [
                '"Login als" erlauben',
                'Allow login as',
        ],
        'settings_allow_loginas_body' => [
                '',
                '',
        ],
        'settings_create_desp_categories_head' => [
                'Create Desp Categories',
                'Create Desp Categories',
        ],
        'settings_create_desp_categories_body' => [
                '',
                '',
        ],
        'settings_disable_shareall_head' => [
                'Mit allen Benutzer:innen teilen deaktivieren',
                'Disable sharing with all users',
        ],
        'settings_disable_shareall_body' => [
                'Klicken Sie <a href="{$a}">hier</a> um alle globalen Freigaben zu löschen',
                'Click <a href="{$a}">here</a>, to remove all global shares',
        ],
        'settings_disable_external_comments_head' => [
                'Teilen von Kommentaren in externen Views deaktivieren',
                'Disable sharing of comments in external view',
        ],
        'settings_disable_external_comments_body' => [
                '',
                '',
        ],
        'block_exaport_app_externaleportfolio_head' => [
                'Dateien in Mahara speichern',
                'Save files to mahara if checked, save to exaport if not checked',
        ],
        'block_exaport_app_externaleportfolio_body' => [
                'App: Setze das Häkchen um Dateien in Mahara zu speichern, ansonsten werden Datein im exabis ePortfolio hinterlegt.',
                'For App',
        ],
        'block_exaport_maxbytes' => [
                'Maximale Upload-Dateigröße in Exabis ePortfolio',
                'Maximum uploaded file size in Exabis ePortfolio',
        ],
        'block_exaport_maxbytes_body' => [
                'Maximale Dateigröße, die Dateien haben können, die im Exabis ePortfolio hochgeladen werden. <br> Wert für diese Seite ist: {$a->sitemaxbytes}. Siehe <a href="{$a->settingsurl}">Einstellungen</a>',
                'This specifies a maximum size that uploaded files can be throughout the Exabis ePortfolio.<br> Value for whole site is: {$a->sitemaxbytes}. See <a href="{$a->settingsurl}">settings</a>',
        ],
        'block_exaport_userquota' => [
                'Benutzer-Dateikontingent Exabis ePortfolio',
                'User quota for Exabis ePortfolio',
        ],
        'block_exaport_userquota_body' => [
                'Maximale Anzahl an Bytes, die ein Benutzer im Exabis ePortfolio hochladen kann. <br> Wert für diese Seite ist: {$a->bytes}. Siehe <a href="{$a->settingsurl}">Einstellungen</a>',
                'The maximum number of bytes that a user can store in their own Exabis ePortfolio.<br> Value for whole site is: {$a->bytes}. See <a href="{$a->settingsurl}">settings</a>',
        ],
        'block_exaport_multiplefilesinitem' => [
                'Mehrere Dateien in Datei-Artefakt hochladen',
                'Multiple files in "File" artifact',
        ],
        'block_exaport_multiplefilesinitem_body' => [
                'limit: 10 Dateien',
                'limit: 10 files',
        ],
        'block_exaport_copytomyportfolio' => [
                'Enable "Copy to my portfolio"',
                'Enable "Copy to my portfolio"',
        ],
        'block_exaport_copytomyportfolio_body' => [
                'User will be able copy artifacts from shared category into own portfolio',
                'User will be able copy artifacts from shared category into own portfolio',
        ],
        'block_exaport_app_alloweditdelete_head' => [
                'Schüler/innen dürfen trotz Lehrerbeurteilungen ePortfolio Items editieren und löschen',
                'Students are allowed to edit and delete items after teacher reviews',
        ],
        'block_exaport_app_alloweditdelete_body' => [
                'Nur in Kombination mit Exabis Competence Grid und Dakora sinnvoll',
                'Only useful in combination with Exabis Competence Grid and dakora',
        ],
        'delete_all_shareall' => [
                'Alle globalen Freigaben "shareall" löschen?',
                'Delete all shareall?',
        ],
        'block_exaport_teachercanseeartifactsofstudents_head' => [
                'Trainer/in hat Zugriff auf alle Artefakte eigene Schüler/innen',
                'Teacher can see ALL artifacts of own students',
        ],
        'block_exaport_teachercanseeartifactsofstudents_body' => [
                'Vertrauenswürdige Trainer/innen müssen im jeweiligen Profil als solche definiert werden. Dies funktioniert nur, wenn obige Option aktiviert ist.<br />{$a}Die Liste der Teilnehmer/innen für jede/n als vertrauenswürdig definierte/n Trainer/in generiert sich automatisch durch Kurseinschreibungen<br />Teilnehmer/innen können diesen Zugriff nicht deaktivieren. Dies hat keine Auswirkungen auf die Gewährung von Zugriffen für andere Teilnehmer/innen.',
                'Trusted teachers have to be configured in their individual profiles and this will only work, if the option above has been activated.<br />{$a}The list of students for each trusted teacher are generated according to their course enrollments.<br />Students cannot disable this access. Access to other users can be given as before.',
        ],
        'block_exaport_teachercanseeartifactsofstudents_configurationlink' => [
                'erforderliches Profilfeld für vertrauenswürdigen Trainer erstellen',
                'Add required user profile field',
        ],
        'block_exaport_confirm_profilefield_create' => [
                'Wollen Sie wirklich das Profilfeld für vertrauenswürdige Trainer erstellen?',
                'Do you really want to add the required profile field?',
        ],
        'block_exaport_confirm_profilefield_exists' => [
                'Das erforderliche Feld existiert bereits',
                'Profile field for trusted teacher already exists',
        ],
        'block_exaport_profilefield_created' => [
                'Das erforderliche Feld wurde hinzugefügt',
                'Profile field for trusted teacher was added',
        ],

        // === Resume.
        'resume_template_newresume' => [
                '<h2>Mein Lebenslauf</h2>',
                '<h2>My new CV</h2>',
        ],
        'resume_my' => [
                'Mein Lebenslauf',
                'My CV',
        ],
        'resume_cover' => [
                'Begleit-Informationen',
                'Personal information',
        ],
        'resume_coversaved' => [
                'Begleit-Informationen gespeichert',
                'Cover saved',
        ],
        'resume_eduhistory' => [
                'Bildungs-Karriere',
                'Education history',
        ],
        'resume_edu' => [
                'Bildung',
                'Education',
        ],
        'resume_edusaved' => [
                'Bildungsverlauf gespeichert',
                'Education saved',
        ],
        'resume_deleteeduconfirm' => [
                'Wollen Sie wirklich den Eintrag löschen?',
                'Do you really want to delete this education?',
        ],
        'resume_edudeleted' => [
                'Eintrag gelöscht',
                'Education deleted',
        ],
        'resume_employhistory' => [
                'Beschäftigungs-Historie',
                'Employment history',
        ],
        'resume_employ' => [
                'Beschäftigung',
                'Employment',
        ],
        'resume_employsaved' => [
                'Beschäftigung gespeichert',
                'Employment saved',
        ],
        'resume_deleteemployconfirm' => [
                'Wollen Sie wirklich den Eintrag löschen?',
                'Do you really want to delete this employment?',
        ],
        'resume_employdeleted' => [
                'Beschäftigung gelöscht',
                'Employment deleted',
        ],
        'resume_interests' => [
                'Interessen',
                'Interests',
        ],
        'resume_interestssaved' => [
                'Interessen gespeichert',
                'Interests saved',
        ],
        'resume_startdate' => [
                'Start-Datum',
                'Start date',
        ],
        'resume_enddate' => [
                'End-Datum',
                'End date',
        ],
        'resume_institution' => [
                'Bildungseinrichtung',
                'Institution ',
        ],
        'resume_institutionaddress' => [
                'Adresse der Bildungseinrichtung',
                'Institution address',
        ],
        'resume_qualification' => [
                'Qualifikation',
                'Qualification',
        ],
        'resume_qualtype' => [
                'Art der Qualifikation',
                'Qualification type',
        ],
        'resume_qualname' => [
                'Bezeichnung der Qualifikation',
                'Qualification name',
        ],
        'resume_qualdescription' => [
                'Beschreibung der Qualifikation',
                'Qualification description',
        ],
        'resume_files' => [
                'Anhang',
                'Attachments',
        ],
        'resume_employer' => [
                'Arbeitgeber',
                'Employer',
        ],
        'resume_employeraddress' => [
                'Adresse des Arbeitgebers',
                'Employer address',
        ],
        'resume_jobtitle' => [
                'Job-Titel',
                'Job title',
        ],
        'resume_position' => [
                'Position',
                'Position',
        ],
        'resume_positiondescription' => [
                'Beschreibung der Position',
                'Position description',
        ],
        'resume_certif' => [
                'Zertifikate, Akkreditierungen, Auszeichnungen',
                'certifications, accreditations and awards',
        ],
        'resume_date' => [
                'Datum',
                'Date',
        ],
        'resume_title' => [
                'Title',
                'Title',
        ],
        'resume_description' => [
                'Beschreibung',
                'description',
        ],
        'resume_certifsaved' => [
                'Zertifikat, Akkreditierung bzw. Auszeichnung gespeichert',
                'Certification, accreditation or award saved',
        ],
        'resume_deletecertifconfirm' => [
                'Wollen Sie wirklich den Eintrag löschen?',
                'Do you really want to delete this certification, accreditation or award?',
        ],
        'resume_certifdeleted' => [
                'Zertifikat, Akkreditierung bzw. Auszeichnung gelöscht',
                'Certification, accreditation or award deleted',
        ],
        'resume_public' => [
                'Bücher und Publikationen',
                'Books and publications',
        ],
        'resume_contribution' => [
                'Beiträge',
                'Contribution',
        ],
        'resume_contributiondetails' => [
                'Details zum Beitrag',
                'Details of your contribution',
        ],
        'resume_url' => [
                'URL',
                'URL',
        ],
        'resume_publicsaved' => [
                'Bücher und Publikationen gespeichert',
                'Books and publications saved',
        ],
        'resume_deletepublicconfirm' => [
                'Wollen Sie wirklich den Eintrag löschen?',
                'Do you really want to delete this book or publication?',
        ],
        'resume_publicdeleted' => [
                'Buch oder Publikation gelöscht',
                'Book or publication deleted',
        ],
        'resume_mbrship' => [
                'Mitgliedschaften',
                'Memberships',
        ],
        'resume_mbrshipsaved' => [
                'Mitgliedschaften gespeichert',
                'Membership saved',
        ],
        'resume_deletembrshipconfirm' => [
                'Wollen Sie wirklich den Eintrag löschen?',
                'Do you really want to delete this membership?',
        ],
        'resume_mbrshipdeleted' => [
                'Mitgliedschaft gelöscht',
                'Membership deleted',
        ],
                        'resume_linkedin' => [
                'LinkedIn-Profil',
                'LinkedIn profile',
        ],
        'resume_linkedinsaved' => [
                'LinkedIn-Profil gespeichert',
                'LinkedIn profile saved',
        ],
        'resume_deletelinkedinconfirm' => [
                'Wollen Sie wirklich den Eintrag löschen?',
                'Do you really want to delete this membership?',
        ],
        'resume_linkedindeleted' => [
                'LinkedIn-Profil gelöscht',
                'LinkedIN profile deleted',
        ],
        'resume_mygoals' => [
                'Meine Ziele',
                'My goals',
        ],
        'resume_goals' => [
                'Ziele',
                'Goals',
        ],
        'resume_goalspersonal' => [
                'persönliche Ziele',
                'Personal goals',
        ],
        'resume_goalsacademic' => [
                'Bildungsziele',
                'Academic goals',
        ],
        'resume_goalscareers' => [
                'Karriereziele',
                'Career goals',
        ],
        'resume_goalspersonalsaved' => [
                'Persönliche Ziele gespeichert',
                'Personal goals saved',
        ],
        'resume_goalsacademicsaved' => [
                'Bildungsziele gespeichert',
                'Academic goals saved',
        ],
        'resume_goalscareerssaved' => [
                'Karriereziele gespeichert',
                'Careers goals saved',
        ],
        'resume_myskills' => [
                'Meine Kompetenzen',
                'My skills',
        ],
        'resume_skills' => [
                'Kompetenzen',
                'Skills',
        ],
        'resume_skillspersonal' => [
                'Persönliche Kompetenzen',
                'Personal skills',
        ],
        'resume_skillsacademic' => [
                'Bildungs-Kompetenzen',
                'Academic skills',
        ],
        'resume_skillscareers' => [
                'Karriere-Kompetenzen',
                'Career skills',
        ],
        'resume_skillspersonalsaved' => [
                'Persönliche Kompetenzen gespeichert',
                'Personal skills saved',
        ],
        'resume_skillsacademicsaved' => [
                'Bildungs-Kompetenzen gespeichert',
                'Academic skills saved',
        ],
        'resume_skillscareerssaved' => [
                'Karriere-Kompetenzen gespeichert',
                'Careers skills saved',
        ],
        'resume_goalscomp' => [
                'Kompetenzen',
                'Educational standards',
        ],
        'resume_skillscomp' => [
                'Kompetenzen',
                'Educational standards',
        ],
        'resume_badges' => [
                'Moodle-Auszeichnungen',
                'Badges',
        ],
        'resume_exportto_europass' => [
                'Export für Europass',
                'Export to Europass',
        ],
        'resume_exportto_europass_intro' => [
                '<p>Das Tool hilft den Nutzerinnen und Nutzern bei der Ermittlung von Lern- und Karrieremöglichkeiten. Im Hinblick auf Beratung und Service-Angebot ist das Profil auch für Arbeitgeber, Freiwilligenorganisationen, Recruiter/innen, Laufbahnberater/innen, Jugendorganisationen, Bildungseinrichtungen und andere Organisationen interessant.</p>
        <p>We provide a way for using your CV from Exabis eProtfolio in Europass profile<br>
            The generated XML-file has to be inserted into the page <a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang=de" target="_blank">Hier kannst du deinen Lebenslauf erstellen</a><br>
            (better to be logged in in the Europass previously)<br>
            Press the button "<strong>Europass-Lebenslauf importieren</strong>" and upload XML-file wich will genareted the button below
        </p>

    Ein paar Kurznotizen:<br>
    <ul><li>Der generierte Lebenslauf sollte auf alle Fälle nochmals kontrolliert werden</li>
        <li>Persönliche Daten werden aus den persönlichen Moodle-Informationen generiert</li>
        <li>Alle Datumsangaben sollten überprüft werden</li>
        <li>Bilder die über die HTML-Editoren eingefügt wurden werden nicht exportiert</li>
        <li>Texte die über die HTML-Editoren eingefügt wurden müssen unter Umständen neu formatiert werden</li>
        <li>Vorgaben für angehängte Dateien: Formate PDF, PNG, JPG sind erlaubt, maximale Dateigröße: 2,5 MB.</li>
    </ul>',
        '<p>The Europass profile can help people to plan their learning and career development. The profile can be used by organisations – employers, volunteer organisations, recruiters, guidance practitioners, youth organisations, education and training institutions and more – as part of the support and services they offer to people.</p>
        <p>We provide a way for using your CV from Exabis eProtfolio in Europass profile<br>
            The generated XML-file has to be inserted into the page <a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang=en" target="_blank">Create your CV</a><br>
            (better to be logged in in the Europass previously)<br>
            Press the button "Import Europass CV" and upload XML-file wich will genareted the button below
        </p>

    Some notes:<br>
    <ul>
        <li>You definitely need to check out the resulting CV</li>
        <li>Your personal data will be taken from your Moodle account</li>
        <li>Please check all dates, telephones, addresses</li>
        <li>Images from the HTML-editors will not be exported</li>
        <li>Most texts from the HTML-editors need to be reformatted</li>
        <li>Attached files are not implemented in new version of Europass, so they will not be imported</li>
    </ul>',
        ],
        'resume_exportto_europass_getXML' => [
                'XML herunterladen',
                'Download XML',
        ],
        'resume_expand' => [
                'Alles öffnen',
                'Expand all',
        ],
        'resume_collaps' => [
                'Alles schließen',
                'Collaps all',
        ],

        // === Structure sharing.
        'shared_categories' => [
                'Geteilte Kategorien',
                'Shared Categories',
        ],
        'nothingstructureshared' => [
                'Keine geteilten Strukturen',
                'Nobody is sharing a structure with you',
        ],
        'browsecategory' => [
                'Inhalt anzeigen',
                'Browse this category',
        ],
        'copycategory' => [
                'In mein Portfolio kopieren',
                'Copy to my Portfolio',
        ],
        'sharedArtefacts' => [
                'Gruppe-Portfolios, die mit dir geteilt wurden',
                'Group portfolios shared with you',
        ],
        'shareditems_category' => [
                'Gruppen-Portfolios, die mit dir geteilt wurden',
                'Group portfolios shared with you',
        ],
        'create_as_note' => [
                'Als Artefakt hinzufügen',
                'Create as Artefact',
        ],
        'category_not_found' => [
                'Kategorie nicht gefunden',
                'Category not found',
        ],
        'root_category' => [
                'Hauptkategorie',
                'Root Category',
        ],
        'current_category' => [
                'Aktuelle Kategorie',
                'Current Category',
        ],
        'change_layout' => [
                'Darstellung wechseln',
                'Change Layout',
        ],
        'details' => [
                'Details',
                'Details',
        ],
        'tiles' => [
                'Kacheln',
                'Tiles',
        ],
        'category_up' => [
                'übergeordnete Kategorie',
                'back to Parent Category',
        ],
        'supported' => [
                'Projekt wurde unterstützt von',
                'supported by',
        ],
        'developed' => [
                'entwickelt von',
                'developed by',
        ],
        'myfilearea' => [
                'Mein Dateibereich',
                'My file area',
        ],
        'show_mystudents' => [
                'Meine Teilnehmer/innen',
                'My students',
        ],
        'show_sharedbyuser' => [
                'von Teilnehmer/innen geteilt',
                'Shared by users',
        ],
        'enrolled_courses' => [
                'mit folgenden Kursen verknüpft',
                'Related with courses',
        ],
        'browseportfolio' => [
                'Inhalt anzeigen',
                'Browse this portfolio',
        ],

        // === Language categories.
        'lang_categories' => [
                null,
                '',
        ],

        // === Message.
        'messageprovider:sharing' => [
                'Nachricht, wenn ein Benutzer/in etwas mit mir teilt',
                'Sharing notifications',
        ],

        // === Not Used Anymore.
        'i_shared' => [
                'Ich habe eine View mit Ihnen geteilt',
                'I shared an eportfolio view with you',
        ],
        'addstdcat' => [
                'Standardkategorien importieren',
                'import standard categories',
        ],
        'incompatible_video' => [
                'Um dieses Video anzusehen, bitte den direkten Link benutzen: {$a->link}',
                'To view this video please use the direct link: {$a->link}',
        ],
        'download_pdf' => [
            'Download as Pdf',
            'Download as Pdf',
        ],
        'pdf_settings' => [
            'PDF-Einstellungen',
            'Pdf settings',
        ],
        'pdf_settings_description' => [
            'If you use some special or uncommon language characters the generated pdf can have problems. So, you can try to use different font settings<br>
            Your PDF settings will be saved for this view.<br>So, if your view is shared with other users - they will see the pdf with your settings.<br>
            Non-standard fonts can have some lost options like bold, italic, e.t.c.',
            'If you use some special or uncommon language characters the generated pdf can have problems. So, you can try to use different font settings<br>
            Your PDF settings will be saved for this view.<br>So, if your view is shared with other users - they will see the pdf with your settings.<br>
            Non-standard fonts can have some lost options like bold, italic, e.t.c.',
        ],
        'pdf_settings_fontfamily' => [
            'Schriftfamilie',
            'Font family',
        ],
        'pdf_settings_fontsize' => [
            'Grundlegende Schriftgröße',
            'Basic font size',
        ],
        'pdf_settings_showmetadata' => [
            'Add view meta data',
            'Add view meta data',
        ],
        'pdf_settings_showusername' => [
            'user name',
            'user name',
        ],
        'pdf_settings_showuserpicture' => [
            'user picture',
            'user picture',
        ],
        'pdf_settings_showuseremail' => [
            'user email',
            'user email',
        ],
        'pdf_settings_showuserphone' => [
            'user phone',
            'user phone',
        ],
        'pdf_customfont' => [
            'Upload custom font',
            'Upload custom font',
        ],
        'pdf_settings_uploadfont' => [
            'Eigene Schriftart hochladen',
            'Upload self font',
        ],
        'pdf_settings_pagesize' => [
            'Seitengröße',
            'Page size',
        ],
        'pdf_settings_pageorient' => [
            'Seitenausrichtung',
            'Page orientation',
        ],
        'pdf_settings_pageorient.portrait' => [
            'Hochformat',
            'Portrait',
        ],
        'pdf_settings_pageorient.landscape' => [
            'Querformat',
            'Landscape',
        ],
        'pdf_customfont_help' => [
            'Your can upload own .ttf file. We will try to use it for PDF generation.',
            'Your can upload own .ttf file. We will try to use it for PDF generation.',
        ],
        'pdf_settings_fontfamily_fixedgroup' => [
            'Predefined fonts',
            'Predefined fonts',
        ],
        'pdf_settings_fontfamily_customgroup' => [
            'Custom uploaded fonts',
            'Custom uploaded fonts',
        ],
        'selected_competencies' => [
            'Erreichte Kompetenz',
            'Achieved Competency'
        ],
        'forms.item.title' => [
            'Titel',
            'Title',
        ],
        'forms.item.title_help' => [
            'Titel help text',
            'Title help text',
        ],
        'view_saved' => [
            'View gespeichert',
            'View saved',
        ],
        'view_sharing_updated' => [
            'Ver&ouml;ffentlichung gespeichert',
            'View sharing updated',
        ],
        'list' => [
            'Liste',
            'List',
        ],
        'what_is_embed_code_title' => [
            'What is embed code?',
            'What is embed code?',
        ],
        'what_is_embed_code_content' => [
            '<p>Embed code is code that is generated by a third-party website such as YouTube or Twitter, that a user can copy and paste into his or her own webpage.  This embedded code will then show the same media, application, or feed on the user\'s web page as it does in the original source.</p>
            <p>We provide instructions for the most popular video vendors such as YouTube or Vimeo.</p>
            <p><strong>Finding the embed code on YouTube:</strong></p>
            <ol>
                <li>Go to YouTube</a>.</li>
                <li>Navigate to the video you wish to embed.</li>
                <li>Click the <strong>Share link</strong> below the video, then click the <strong>Embed link</strong>.</li>
                <li>Press <strong>Copy</strong> button in the footer of opened window.</li>
                <li>The embed link will be highlighted in blue and copied to the clipboard.</li>
                <li>Past the code to exabis E-portfolio textarea field.</li>
            </ol>
            <p><strong>Finding the embed code on Vimeo:</strong></p>
            <ol>
                <li>Go to Vimeo.</li>
                <li>Navigate to the video you wish to embed.</li>
                <li>Click the <strong>Share</strong> button, in the top right corner of your video.</li>
                <li>A pop-up will appear with the embed link information. You will need to copy only the <strong>&lt;<i>iframe</i>&gt;</strong> portion of the embed link.
                    Example:<br>                    
                    <ol>
                        <li>
                            Entire embed link shows the following:<br>
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Automation Opening[2]&lt;/a&gt; from &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; on &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea>                            
                        </li>
                        <li>
                            You only need to copy the <strong>&lt;<i>iframe</i>&gt;</strong> portion:<br>                            
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;</textarea>                            
                        </li>                    
                    </ol>
                <li>Past this code to exabis E-portfolio textarea field.</li>
            </ol>
            ',
            '<p>Embed code is code that is generated by a third-party website such as YouTube or Twitter, that a user can copy and paste into his or her own webpage.  This embedded code will then show the same media, application, or feed on the user\'s web page as it does in the original source.</p>
            <p>We provide instructions for the most popular video vendors such as YouTube or Vimeo.</p>
            <p><strong>Finding the embed code on YouTube:</strong></p>
            <ol>
                <li>Go to YouTube</a>.</li>
                <li>Navigate to the video you wish to embed.</li>
                <li>Click the <strong>Share link</strong> below the video, then click the <strong>Embed link</strong>.</li>
                <li>Press <strong>Copy</strong> button in the footer of opened window.</li>
                <li>The embed link will be highlighted in blue and copied to the clipboard.</li>
                <li>Past the code to exabis E-portfolio textarea field.</li>
            </ol>
            <p><strong>Finding the embed code on Vimeo:</strong></p>
            <ol>
                <li>Go to Vimeo.</li>
                <li>Navigate to the video you wish to embed.</li>
                <li>Click the <strong>Share</strong> button, in the top right corner of your video.</li>
                <li>A pop-up will appear with the embed link information. You will need to copy only the <strong>&lt;<i>iframe</i>&gt;</strong> portion of the embed link.
                    Example:<br>                    
                    <ol>
                        <li>
                            Entire embed link shows the following:<br>
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Automation Opening[2]&lt;/a&gt; from &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; on &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea>                            
                        </li>
                        <li>
                            You only need to copy the <strong>&lt;<i>iframe</i>&gt;</strong> portion:<br>                            
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;</textarea>                            
                        </li>                    
                    </ol>
                <li>Past this code to exabis E-portfolio textarea field.</li>
            </ol>
            ',
        ],

        // === Privacy wordings
        'privacy:metadata:block_exaportuser' => [
            'user\'s data from exabis e-portfolio',
            'user\'s data from exabis e-portfolio',
        ],
        'privacy:metadata:block_exaportuser:user_id' => [
            'user id',
            'user id',
        ],
        'privacy:metadata:block_exaportuser:description' => [
            'description',
            'description',
        ],
        'privacy:metadata:block_exaportuser:view_items_layout' => [
            'user id',
            'user id',
        ],

        'privacy:metadata:block_exaportcate' => [
            'user\'s categories',
            'user\'s categories',
        ],
        'privacy:metadata:block_exaportcate:pid' => [
            'parent category id',
            'parent category id',
        ],
        'privacy:metadata:block_exaportcate:userid' => [
            'user id',
            'user id',
        ],
        'privacy:metadata:block_exaportcate:name' => [
            'title',
            'title',
        ],
        'privacy:metadata:block_exaportcate:timemodified' => [
            'last modified',
            'last modified',
        ],
        'privacy:metadata:block_exaportcate:courseid' => [
            'course id',
            'course id',
        ],
        'privacy:metadata:block_exaportcate:description' => [
            'description',
            'description',
        ],
        'privacy:metadata:block_exaportcate:subjid' => [
            'related subject id',
            'related subject id',
        ],
        'privacy:metadata:block_exaportcate:topicid' => [
            'related topic id',
            'related topic id',
        ],
        'privacy:metadata:block_exaportcate:source' => [
            'source',
            'source',
        ],
        'privacy:metadata:block_exaportcate:sourceid' => [
            'source id',
            'source id',
        ],
        'privacy:metadata:block_exaportcate:parent_ids' => [
            'list of parent ids',
            'list of parent ids',
        ],
        'privacy:metadata:block_exaportcate:parent_titles' => [
            'list of parent titles',
            'list of parent titles',
        ],
        'privacy:metadata:block_exaportcate:stid' => [
            'schooltype id',
            'schooltype id',
        ],
        'privacy:metadata:block_exaportcate:sourcemod' => [
            'sourcemod',
            'sourcemod',
        ],
        'privacy:metadata:block_exaportcate:name_short' => [
            'short title',
            'short title',
        ],
        'privacy:metadata:block_exaportcate:shareall' => [
            'shared for all? 0 - did not share; 1 - shared for all; 2 - shared for groups',
            'shared for all? 0 - did not share; 1 - shared for all; 2 - shared for groups',
        ],
        'privacy:metadata:block_exaportcate:internshare' => [
            'internal share?',
            'internal share?',
        ],
        'privacy:metadata:block_exaportcate:structure_shareall' => [
            'shared as structure? : 0 - did not share; 1 - shared for all; 2 - shared for groups',
            'shared as structure? : 0 - did not share; 1 - shared for all; 2 - shared for groups',
        ],
        'privacy:metadata:block_exaportcate:structure_share' => [
            'shared as structure? look also \'structure_shareall\'',
            'shared as structure? look also \'structure_shareall\'',
        ],

        'privacy:metadata:block_exaportitem' => [
            'user\'s artifact',
            'user\'s artifact',
        ],
        'privacy:metadata:block_exaportitem:userid' => [
            'artifact\'s owner',
            'artifact\'s owner',
        ],
        'privacy:metadata:block_exaportitem:type' => [
            'type of artifact',
            'type of artifact',
        ],
        'privacy:metadata:block_exaportitem:categoryid' => [
            'category id',
            'category id',
        ],
        'privacy:metadata:block_exaportitem:name' => [
            'name',
            'name',
        ],
        'privacy:metadata:block_exaportitem:url' => [
            'url',
            'url',
        ],
        'privacy:metadata:block_exaportitem:intro' => [
            'intro',
            'intro',
        ],
        'privacy:metadata:block_exaportitem:timemodified' => [
            'last modified time',
            'last modified time',
        ],
        'privacy:metadata:block_exaportitem:courseid' => [
            'course id',
            'course id',
        ],
        'privacy:metadata:block_exaportitem:shareall' => [
            'shared for all?',
            'shared for all?',
        ],
        'privacy:metadata:block_exaportitem:externaccess' => [
            'external access?',
            'external access?',
        ],
        'privacy:metadata:block_exaportitem:externcomment' => [
            'comment for externals',
            'comment for externals',
        ],
        'privacy:metadata:block_exaportitem:fileurl' => [
            'url to file',
            'url to file',
        ],
        'privacy:metadata:block_exaportitem:exampid' => [
            'related example id',
            'related example id',
        ],
        'privacy:metadata:block_exaportitem:langid' => [
            'language id',
            'language id',
        ],
        'privacy:metadata:block_exaportitem:source' => [
            'source',
            'source',
        ],
        'privacy:metadata:block_exaportitem:sourceid' => [
            'source id',
            'source id',
        ],
        'privacy:metadata:block_exaportitem:iseditable' => [
            'is editable?',
            'is editable?',
        ],
        'privacy:metadata:block_exaportitem:example_url' => [
            'example_url',
            'artifact\'s owner',
        ],
        'privacy:metadata:block_exaportitem:parentid' => [
            'parent id',
            'parent id',
        ],

        'privacy:metadata:block_exaportitemcomm' => [
            'comments for artifacts',
            'comments for artifacts',
        ],
        'privacy:metadata:block_exaportitemcomm:itemid' => [
            'id of artifact',
            'id of artifact',
        ],
        'privacy:metadata:block_exaportitemcomm:userid' => [
            'author of comment',
            'author of comment',
        ],
        'privacy:metadata:block_exaportitemcomm:entry' => [
            'comment',
            'comment',
        ],
        'privacy:metadata:block_exaportitemcomm:timemodified' => [
            'last modified',
            'last modified',
        ],

        'privacy:metadata:block_exaportview' => [
            'comments for artifacts',
            'comments for artifacts',
        ],
        'privacy:metadata:block_exaportview:userid' => [
            'owner of view',
            'owner of view',
        ],
        'privacy:metadata:block_exaportview:name' => [
            'name',
            'name',
        ],
        'privacy:metadata:block_exaportview:description' => [
            'description',
            'description',
        ],
        'privacy:metadata:block_exaportview:timemodified' => [
            'last modified',
            'last modified',
        ],
        'privacy:metadata:block_exaportview:shareall' => [
            'shared for all?',
            'shared for all?',
        ],
        'privacy:metadata:block_exaportview:externaccess' => [
            'external access?',
            'external access?',
        ],
        'privacy:metadata:block_exaportview:externcomment' => [
            'comment from external?',
            'comment from external?',
        ],
        'privacy:metadata:block_exaportview:langid' => [
            'language id',
            'language id',
        ],
        'privacy:metadata:block_exaportview:layout' => [
            'layout of the view',
            'layout of the view',
        ],
        'privacy:metadata:block_exaportview:sharedemails' => [
            'shared emails list',
            'shared emails list',
        ],
        'privacy:metadata:block_exaportview:autofill_artefacts' => [
            'enabled autofill by artifacts',
            'enabled autofill by artifacts',
        ],

        'privacy:metadata:block_exaportresume' => [
            'resume data',
            'resume data',
        ],
        'privacy:metadata:block_exaportresume:user_id' => [
            'resume owner',
            'resume owner',
        ],
        'privacy:metadata:block_exaportresume:courseid' => [
            'course id',
            'course id',
        ],
        'privacy:metadata:block_exaportresume:cover' => [
            'cover content',
            'cover content',
        ],
        'privacy:metadata:block_exaportresume:interests' => [
            'interests',
            'interests',
        ],
        'privacy:metadata:block_exaportresume:goalspersonal' => [
            'personal goals',
            'personal goals',
        ],
        'privacy:metadata:block_exaportresume:goalsacademic' => [
            'academic goals',
            'academic goals',
        ],
        'privacy:metadata:block_exaportresume:goalscareers' => [
            'careers goals',
            'careers goals',
        ],
        'privacy:metadata:block_exaportresume:skillspersonal' => [
            'personal skills',
            'personal skills',
        ],
        'privacy:metadata:block_exaportresume:skillsacademic' => [
            'academic skills',
            'academic skills',
        ],
        'privacy:metadata:block_exaportresume:skillscareers' => [
            'careers skills',
            'careers skills',
        ],
        'privacy:metadata:core_files' => [
            'Exabis ePortfolio stores files which have been uploaded by the user to form part of artifacts, resume entries and comments.',
            'Exabis ePortfolio stores files which have been uploaded by the user to form part of artifacts, resume entries and comments.',
        ],




];
?>