<?php
// This file is part of Exabis Eportfolio (extension for Moodle)
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
// (c) 2016 GTN - Global Training Network GmbH <office@gtn-solutions.com>.

$string['translation:language'] = 'English';
$string['translation:person'] = 'Andreas Riepl';
$string['translation:organisation'] = 'IZ Steyr';
$string['translation:email'] = 'ariepl.work@gmail.com';

// === Main ===
// Shown in admin plugin list.
$string['pluginname'] = 'Exabis ePortfolio';
// === Shown in block title and all headers.
$string['blocktitle'] = 'Exabis ePortfolio';
$string['exaport:use'] = 'Use allowed';
$string['exaport:addinstance'] = 'add Exabis ePortfolio to the course';
$string['exaport:myaddinstance'] = 'add Exabis ePortfolio on My home';
$string['exaport:export'] = 'Export of SCORM-Files';
$string['exaport:import'] = 'Import of SCORM-Files';
$string['exaport:importfrommoodle'] = 'Import from Moodle';
$string['exaport:shareintern'] = 'Internal sharing of views';
$string['exaport:shareextern'] = 'External sharing of views';
$string['exaport:allowposts'] = 'Allow posting';
$string['exaport:competences'] = 'Allow competences';
$string['exaport:viewartifactsfromstudents'] = 'Can see portfolio artifacts of own students';
$string['new'] = 'New';
$string['addbookmark'] = 'Add bookmark';
$string['addcategory'] = 'Add category';
$string['attachment'] = 'attachment';
$string['attachincluded'] = 'attachment?';
$string['awaiting'] = '($a awaiting)';
$string['back'] = 'Back';
$string['close'] = 'close';
$string['backtocourse'] = 'Back to course';
$string['categories'] = 'Categories';
$string['explaincategories'] = 'Categories: here you can create and modify categories';
$string['category'] = 'Category';
$string['categoryhead'] = 'Category name';
$string['categorysaved'] = 'Category added.';
$string['categoryedited'] = 'Category saved.';
$string['categorydeleted'] = 'Category deleted.';
$string['date'] = 'Date';
$string['dontincludeurl'] = 'Check this box to unassociate the bookmark with the URL';
$string['duplicatedurl'] = 'You already have this URL bookmarked.';
$string['editcategories'] = 'edit categories';
$string['explaining'] = 'The Portfolio may be used to store web addresses, files, as well as enter notes that may contain insights or little notes the user may wish to write down.';
$string['explaininglink'] = 'Links.  These links may be shared with all authorized course members.';
$string['explainingfile'] = 'Files. These files may be shared with all authorized course members.';
$string['explainingnote'] = 'Notes. These notes may be shared with all authorized course members.';
$string['explainingshare'] = 'To allow a participant to see the link, click on their name and then click on Save Changes. You can choose more than one participant.';
$string['explainingshared'] = 'These participants have shared some of their external links, files or notes.';
$string['explainingsharefile'] = 'To allow a participant to see the file, click on their name and then click on Save Changes.  You can choose more than one participant.';
$string['explainingsharenote'] = 'To allow a participant to see the note, click on their name and then click on Save Changes.  You can choose more than one participant.';
$string['file'] = 'File';
$string['iconfile'] = 'Icon picture';
$string['iconfile_merge'] = 'Merge this icon picture with the folder icon';
$string['iconfile_merge_description'] = 'Icon picture will try (without any guarantee) to merge with standard folder icon. The icon will be replaced with the new image.';
$string['firstnameshared'] = 'First Name';
$string['go'] = 'Go!';
$string['hidesummary'] = '(hide summary)';
$string['managecategories'] = 'Manage categories';
$string['mandatoryfields'] = 'The field\'s name, category and intro are required. Please fill them in.';
$string['mandatoryfieldsforcat'] = 'The field name is required. Please fill them in.';
$string['myportfolio'] = 'My Portfolio Artifacts';
$string['myportfoliotitle'] = 'Exabis ePortfolio module: Add your links and files here.';
$string['newlink'] = 'Add new link';
$string['newfile'] = 'Add new file';
$string['newnote'] = 'Add new note';
$string['nocategories'] = '(no categories yet)';
$string['nobookmarksall'] = '(no items yet)';
$string['nobookmarkslink'] = '(no links yet)';
$string['nobookmarksfile'] = '(no files yet)';
$string['nobookmarksnote'] = '(no notes yet)';
$string['noentry'] = 'No entry';
$string['note'] = 'Note';
$string['notetitle'] = 'Note';
$string['shared_views'] = 'Shared Views';
$string['showall'] = 'Show Other Courses Too';
$string['showcourse'] = 'Show This Course Only';
$string['showsummary'] = '(show summary)';
$string['strshare'] = 'Share';
$string['strunshare'] = 'Unshare';
$string['summary'] = 'Summary (optional)';
$string['url'] = 'URL';
$string['maincategory'] = 'Main category';
$string['subcategory'] = 'Sub category';
$string['accessoptions'] = 'Who has access?';
$string['shareallexceptthose'] = 'Access for <span class=\'block_eportfolio_bold\'>all</span> (even those who aren\'t listed here) except the following users';
$string['sharenoneexceptthose'] = 'Access for <span class=\'block_eportfolio_bold\'>nobody</span> except the following users';
$string['internalaccessall'] = 'Access for <span class=\'block_eportfolio_bold\'>all</span>';
$string['internalaccessusers'] = 'Access only for the following users';
$string['internalaccessgroups'] = 'Access only for the following groups';
$string['externaccess'] = 'external ePortfolio-Link';
$string['emailaccess'] = 'Share by Email';
$string['emailaccessdescription'] = 'Input an email address per line<br />Each email will receive a unique link with access to this view. Deleting the email will remove access to this view.';
$string['emailaccessmessagesubject'] = 'New shared View for you';
$string['emailaccessmessage'] = 'Hello! {$a->sendername} has shared the view "{$a->viewname}" for you. You can view it here: {$a->url}';
$string['emailaccessmessageHTML'] = 'Hello!<br />{$a->sendername} has shared the view "{$a->viewname}" for you.<br />You can view it <a href="{$a->url}">here</a>.';
$string['showallusers'] = 'Show users of all my courses';
$string['showcourseusers'] = 'Show only users of the course';
$string['sharedpersons'] = 'Persons with shared Portfolios';
$string['moodleimport'] = 'Import from Moodle-assignments';
$string['nomoodleimportyet'] = 'At the moment you have no submission at any assignment!';
$string['deletecategoryconfirm'] = 'Do you really want to delete the category "{$a->name}"? All entries in this category and all subcategories will be deleted!';
$string['name'] = 'Name';
$string['role'] = 'Role';
$string['nousersfound'] = 'No users found';
$string['delete'] = 'Delete';
$string['add'] = 'Add';
$string['edit'] = 'Edit';
$string['checkall'] = 'Check all';
$string['grouptitle'] = 'Group title';
$string['membercount'] = 'Number of members';
$string['nogroupsfound'] = 'No groups found';
$string['make_it_yours'] = 'Make it yours';

// === Export/import.
$string['import'] = 'Import SCORM-File';
$string['import_short'] = 'Import';
$string['explainexport'] = 'Export your portfolio here.';
$string['createexport'] = 'Create SCORM-File';
$string['clicktodownloadscorm'] = 'Press button to download the SCORM file:';
$string['add_directory_structure'] = 'Add directory-structure';
$string['download'] = 'Download';
$string['endedit'] = 'End editing';
$string['change'] = 'Change';
$string['explainpersonal'] = 'Personal information';
$string['personal'] = 'Information';
$string['descriptionsaved'] = 'description saved';
$string['course'] = 'Course';
$string['importexport'] = 'Import/Export';
$string['explainimport'] = 'Here you can import a SCORM-File into the portfolio. If markers from previous exports are found the import tries to import the data in the existing filestructure.';
$string['makeimport'] = 'Import';
$string['add_this_file'] = 'add this file';
$string['bookmarksall'] = 'All Items';
$string['bookmarkslinks'] = 'Links';
$string['bookmarksfiles'] = 'Files';
$string['bookmarksnotes'] = 'Notes';
$string['noguestpost'] = 'Guests don\'t have access here!';
$string['comments'] = 'Comments';
$string['addcomment'] = 'Add comment';
$string['externcomment'] = 'Share comments in external portfolio';
$string['itemgrading'] = 'Grading';
$string['gradeitem'] = 'Grade the item';
$string['submititem'] = 'Submit';
$string['saveitem'] = 'Save';

// === Notes.
$string['deletenoteconfirm'] = 'Do you really want to delete this note?';
$string['deletelinkconfirm'] = 'Do you really want to delete this link?';
$string['deletefileconfirm'] = 'Do you really want to delete this file?';

// === Different.
$string['couldninsertcomment'] = 'Couldn\'t insert comment!';
$string['importedcommentsstart'] = 'Imported comments:<br /><br />';
$string['importedcommentsend'] = 'End of imported comments';
$string['filetypenotdetected'] = 'Filetype of $a->filename ($a->title) could not be detected. File not imported!';
$string['linkedfilenotfound'] = 'File $a->filename in $a->url ($a->title) was not found. File not imported!';
$string['couldntinsert'] = 'Couldn\'t insert $a into database';
$string['couldntcreatedirectory'] = 'Couldn\'t create directory';
$string['couldntcopyfile'] = 'Couldn\'t copy file for $a! File not imported.';
$string['success'] = 'File imported successful';
$string['couldntinsertcategory'] = 'Could not insert category!';
$string['couldntupdatecategory'] = 'Could not update category!';
$string['couldntextractscormfile'] = 'Couldn\'t extract SCORM-file!';
$string['couldntcreatetempdir'] = 'Couldn\'t create temporary directory!';
$string['scormhastobezip'] = 'SCORM-File has to be a .zip-File';
$string['uploadfailed'] = 'Upload failed.';
$string['couldntupdatedesc'] = 'Could not update your description!';
$string['couldntinsertdesc'] = 'Could not insert the description!';
$string['exportcomment'] = 'This is an exported file from Exabis ePortfolio. Please do not remove the comments, they are needed for the import!';
$string['comment'] = 'Comment';
$string['commentshouldnotbeempty'] = 'You have to enter a comment.';
$string['title'] = 'Title';
$string['titlenotemtpy'] = 'You have to enter a title.';
$string['intro'] = 'Content';
$string['intronotempty'] = 'You have to enter a content.';
$string['link'] = 'Link';
$string['categorynotempty'] = 'You have to choose a category.';
$string['urlnotempty'] = 'You have to enter an URL.';
$string['selectall'] = 'Select All';
$string['deselectall'] = 'Deselect All';
$string['internalaccess'] = 'Internal Access';
$string['externalaccess'] = 'External Access';
$string['loginasmode'] = 'You can\'t access portfolios in \'Login As\'-Mode.';
$string['badsessionkey'] = 'Bad Session Key';
$string['invalidinstance'] = 'That\'s an invalid instance';
$string['invalidcourseid'] = 'That\'s an invalid course id';
$string['wronglinkid'] = 'Wrong link id';
$string['incorrectlinksid'] = 'Incorrect links post id';
$string['incorrectnoteid'] = 'Incorrect note id';
$string['unknownaction'] = 'Unknown action';
$string['filenotfound'] = 'File not found';
$string['wrongfileid'] = 'Wrong file id';
$string['wrongfilepostid'] = 'Wrong file id';
$string['wrongnoteid'] = 'Wrong note id';
$string['wrongnotepostid'] = 'Wrong note postbid';
$string['bookmarknotfound'] = 'Bookmark not found';
$string['commentnotfound'] = 'Comment not found';
$string['updateposterror'] = 'There was an error updating this post in the database';
$string['deleteposterror'] = 'Error occured while deleting post';
$string['addposterror'] = 'There was an error adding this post in the database';
$string['invalidassignmentid'] = 'Invalid assignment id';
$string['invalidfileatthisassignment'] = 'File does not exist at this assignment!';
$string['publishedportfolios'] = 'Published portfolios';
$string['viewcategories'] = 'manage categories';
$string['updownarrow'] = 'updown arrow';
$string['comment_delete_confirmation'] = 'Do you really want to delete this comment?';

// Shared portfolios.
$string['nocoursetogether'] = 'No Course';
$string['nothingshared'] = 'Nobody is sharing a portfolio with you';

// === Errors.
$string['nouserforid'] = 'User not found (id unknown)';
$string['nouserforaccess'] = 'User not found (access-code unknown)';

// === Export.
$string['export'] = 'Export SCORM-File';
$string['export_short'] = 'Export';
$string['exportepx'] = 'Export EPX-File';
$string['createepxexport'] = 'Create EPX-File';
$string['exportviewselect'] = 'To export all items of a specific view, please select it here';
$string['export_directory'] = 'Export Directory-structure';
$string['createexport_directory'] = 'Create Directory-structure';

// === Stuff.
$string['type'] = 'Type';
$string['share'] = 'Share';
$string['explainingall'] = 'All Items in your portfolio';
$string['share_to_other_users'] = 'Search Users';
$string['other_users_course'] = 'Users not in my courses';
$string['other_groups_course'] = 'Other courses';

// === Item sorting.
$string['userdefinedsort'] = 'Define your own search';
$string['movetop'] = 'Move top';
$string['movebottom'] = 'Move bottom';

// === Views.
$string['view'] = 'View';
$string['views'] = 'My Views';
$string['explainingviews'] = 'Manage your views.';
$string['noviews'] = 'Please create a new View';
$string['viewnotfound'] = 'View not found';
$string['newview'] = 'Add View';
$string['viewinformation'] = 'View Information';
$string['viewdescription'] = 'description';
$string['viewdesign'] = 'View Design';
$string['viewitems'] = 'Your Items';
$string['viewitem'] = 'Item';
$string['view_specialitems'] = 'Special Items';
$string['view_specialitem_headline'] = 'Headline';
$string['view_specialitem_personal'] = 'Personal information';
$string['view_specialitem_text'] = 'Text';
$string['view_specialitem_media'] = 'Media';
$string['view_specialitem_badge'] = 'Badge';
$string['view_specialitem_headline_defaulttext'] = 'Enter Headline Here';
$string['view_specialitem_text_defaulttext'] = 'Enter Text Here';
$string['view_sharing'] = 'Sharing';
$string['viewand'] = 'and';
$string['view_sharing_noaccess'] = 'No Access';
$string['show'] = 'Show';
$string['thiscourse'] = 'This course';
$string['othercourses'] = 'other courses';
$string['autofillview'] = 'Automatically add all available artefacts to this view';
$string['sharetoteacher'] = 'Share to all teachers in this course';
$string['createpage'] = 'Drag and drop content blocks from the tabs below to create your page.';
$string['chooselayout'] = 'Select how you would like the columns in your page to be laid out.';
$string['viewtitle'] = 'Title and description';
$string['viewcontent'] = 'Content';
$string['viewlayout'] = 'Layout';
$string['viewshare'] = 'Share';
$string['viewlayoutgroup1'] = '1 column';
$string['viewlayoutgroup2'] = '2 columns';
$string['viewlayoutgroup3'] = '3 columns';
$string['viewlayoutgroup4'] = '4 columns';
$string['viewlayoutgroup5'] = '5 columns';
$string['viewlayout1'] = 'Equal widths';
$string['viewlayout2'] = 'Equal widths';
$string['viewlayout3'] = 'Larger left column';
$string['viewlayout4'] = 'Larger right column';
$string['viewlayout5'] = 'Equal widths';
$string['viewlayout6'] = 'Larger centre column';
$string['viewlayout7'] = 'Much larger centre column';
$string['viewlayout8'] = 'Equal widths';
$string['viewlayout9'] = 'Larger centre columns';
$string['viewlayout10'] = 'Equal widths';
$string['personalinformation'] = 'Personal Information';
$string['cvinformation'] = 'CV Information';
$string['headertext'] = 'Headertext';
$string['item'] = 'Item';
$string['items'] = 'Items';
$string['media'] = 'Media';
$string['fieldstoshow'] = 'Fields to show';
$string['listofartefacts'] = 'List of Artefacts';
$string['listofbadges'] = 'List of Badges';
$string['addButton'] = 'Add';
$string['saveButton'] = 'Save';
$string['cancelButton'] = 'Cancel';
$string['blocktitle2'] = 'Block title';
$string['blockcontent'] = 'Block content';
$string['firstname'] = 'First name';
$string['lastname'] = 'Last name';
$string['profilepicture'] = 'Profile picture';
$string['nopicture'] = 'no picture';
$string['noprofilepicture'] = 'no profile picture available';
$string['mailadress'] = 'Email adress';
$string['nomail'] = 'no email';
$string['noemails'] = 'no email adress available';
$string['aboutme'] = 'About me';
$string['notify'] = 'notify';
$string['sharejs'] = 'share';
$string['mediacontent'] = 'URL or embed code *';
$string['height'] = 'Height';
$string['width'] = 'Width';
$string['media_allowed_notes'] = 'URLs from the following sites are allowed:';
$string['filterByTag'] = 'Filter by tag';
$string['tagarea_block_exaportitem'] = 'My Portfolio Artifacts';
$string['searchByTitle'] = 'Search';
$string['clearAllFilers'] = 'Clear all filters';
$string['sharedwith'] = 'Shared with';
$string['sharedwith_user_cnt'] = 'Shared with {$a} users';
$string['sharedwith_onlyme'] = 'Shared only with me';
$string['sharedwith_shareall'] = 'Shared with all users';
$string['sharedwith_shareexternal'] = 'Shared external';
$string['sharedwith_group'] = 'Shared with my group';
$string['sharedwith_group_cnt'] = 'Shared with {$a} groups';

// === Copy to course.
$string['filecopiedtocourse'] = 'File copied to course $a->coursename under the name of $a->filename';
$string['copyitemtocourse'] = 'Copy to course';
$string['desp_language'] = 'Desp Language';
$string['cofigureblock'] = 'Configure Block';
$string['selectitems'] = 'Select items';
$string['cofigureblock_text'] = 'Choose text';
$string['cofigureblock_header'] = 'Choose headline';
$string['cofigureblock_item'] = 'Choose item';
$string['cofigureblock_media'] = 'Choose media';
$string['cofigureblock_personalinfo'] = 'Choose personal info';
$string['cofigureblock_cvinfo'] = 'Choose cv info';
$string['cofigureblock_badge'] = 'Choose Badges';
$string['cofigureblock_cvinfo_education_history'] = 'Education history';
$string['cofigureblock_cvinfo_employment_history'] = 'Employment history';
$string['cofigureblock_cvinfo_certif'] = 'certifications, accreditations and awards';
$string['cofigureblock_cvinfo_public'] = 'Books and publications';
$string['cofigureblock_cvinfo_mbrship'] = 'Memberships';
$string['cofigureblock_cvinfo_goals'] = 'My goals';
$string['cofigureblock_cvinfo_skills'] = 'My skills';
$string['cofigureblock_cvinfo_interests'] = 'Interests';
$string['in'] = 'at';
$string['cofigureblock_cvinfo_withfiles'] = 'With attachment files';

// === Desp.
$string['back_to_desp'] = 'back to language portfolio';
$string['desp_pluginname'] = 'Dossier';
$string['steckbrief'] = 'Profile';
$string['desp_categories'] = '
    stories, roleplays, essays, collagen
    curriculum vitae
    reviews of theatre productions, exhibitions
    project reports and reflections
    audio- and videoclips
    encounters with other nationalities
    thoughts about your language skills
    report cards
    certificates
    acknowledgements
    listening
     - individual work
     - partner work
     - group work
    reading
     - individual work
     - partner work
     - group work
    participating in conversations
     - individual work
     - partner work
     - group work
    speaking fluently
     - individual work
     - partner work
     - group work
    writing
     - individual work
     - partner work
     - group work
';

// === Config.
$string['config_feature_copy_to_course'] = 'Allow students to copy ePortfolio files to their courses';
$string['competenceinteraction'] = 'Allow interaction with block Exabis Competence Grid, in case it is installed';
$string['opencomps'] = 'Choose your competences';
$string['selectcomps'] = 'Choose competences associated with your upload!';
$string['competences_old_version'] = 'An outdated version of Exabis Competences that is no longer supported by Exabis Eportfolio is installed on this moodle.';
$string['expandcomps'] = 'Expand all';
$string['contactcomps'] = 'Contract all';
$string['studentcomps'] = 'Here you can self-assess whether you have acquired the competency with your artefact.';
$string['teachercomps'] = 'Here you can assess whether your students have acquired the competency with this artefact.';
$string['competences'] = 'competences';
$string['desp_einleitung'] = 'Here is your portfolio. You can show others what you have accomplished by yourself.';
$string['settings_interaktion_exacomp_head'] = 'Interaction exabis ePortfolio - Exabis Competence Grid';
$string['settings_interaktion_exacomp_body'] = 'Interaction with block Exabis Competence Grid, in case it is installed';
$string['settings_allow_loginas_head'] = 'Allow login as';
$string['settings_allow_loginas_body'] = '';
$string['settings_create_desp_categories_head'] = 'Create Desp Categories';
$string['settings_create_desp_categories_body'] = '';
$string['settings_disable_shareall_head'] = 'Disable sharing with all users';
$string['settings_disable_shareall_body'] = 'Click <a href="{$a}">here</a>, to remove all global shares';
$string['settings_disable_external_comments_head'] = 'Disable sharing of comments in external view';
$string['settings_disable_external_comments_body'] = '';
$string['block_exaport_app_externaleportfolio_head'] = 'Save files to mahara if checked, save to exaport if not checked';
$string['block_exaport_app_externaleportfolio_body'] = 'For App';
$string['block_exaport_maxbytes'] = 'Maximum uploaded file size in Exabis ePortfolio';
$string['block_exaport_maxbytes_body'] = 'This specifies a maximum size that uploaded files can be throughout the Exabis ePortfolio.<br> Value for whole site is: {$a->sitemaxbytes}. See <a href="{$a->settingsurl}">settings</a>';
$string['block_exaport_userquota'] = 'User quota for Exabis ePortfolio';
$string['block_exaport_userquota_body'] = 'The maximum number of bytes that a user can store in their own Exabis ePortfolio.<br> Value for whole site is: {$a->bytes}. See <a href="{$a->settingsurl}">settings</a>';
$string['block_exaport_multiplefilesinitem'] = 'Multiple files in "File" artifact';
$string['block_exaport_multiplefilesinitem_body'] = 'limit: 10 files';
$string['block_exaport_copytomyportfolio'] = 'Enable "Copy to my portfolio"';
$string['block_exaport_copytomyportfolio_body'] = 'User will be able copy artifacts from shared category into own portfolio';
$string['block_exaport_app_alloweditdelete_head'] = 'Students are allowed to edit and delete items after teacher reviews';
$string['block_exaport_app_alloweditdelete_body'] = 'Only useful in combination with Exabis Competence Grid and dakora';
$string['delete_all_shareall'] = 'Delete all shareall?';
$string['block_exaport_teachercanseeartifactsofstudents_head'] = 'Teacher can see ALL artifacts of own students';
$string['block_exaport_teachercanseeartifactsofstudents_body'] = 'Trusted teachers have to be configured in their individual profiles and this will only work, if the option above has been activated.<br />{$a}The list of students for each trusted teacher are generated according to their course enrollments.<br />Students cannot disable this access. Access to other users can be given as before.';
$string['block_exaport_teachercanseeartifactsofstudents_configurationlink'] = 'Add required user profile field';
$string['block_exaport_confirm_profilefield_create'] = 'Do you really want to add the required profile field?';
$string['block_exaport_confirm_profilefield_exists'] = 'Profile field for trusted teacher already exists';
$string['block_exaport_profilefield_created'] = 'Profile field for trusted teacher was added';

// === Resume.
$string['resume_template_newresume'] = '<h2>My new CV</h2>';
$string['resume_my'] = 'My CV';
$string['resume_cover'] = 'Personal information';
$string['resume_coversaved'] = 'Cover saved';
$string['resume_eduhistory'] = 'Education history';
$string['resume_edu'] = 'Education';
$string['resume_edusaved'] = 'Education saved';
$string['resume_deleteeduconfirm'] = 'Do you really want to delete this education?';
$string['resume_edudeleted'] = 'Education deleted';
$string['resume_employhistory'] = 'Employment history';
$string['resume_employ'] = 'Employment';
$string['resume_employsaved'] = 'Employment saved';
$string['resume_deleteemployconfirm'] = 'Do you really want to delete this employment?';
$string['resume_employdeleted'] = 'Employment deleted';
$string['resume_interests'] = 'Interests';
$string['resume_interestssaved'] = 'Interests saved';
$string['resume_startdate'] = 'Start date';
$string['resume_enddate'] = 'End date';
$string['resume_institution'] = 'Institution ';
$string['resume_institutionaddress'] = 'Institution address';
$string['resume_qualification'] = 'Qualification';
$string['resume_qualtype'] = 'Qualification type';
$string['resume_qualname'] = 'Qualification name';
$string['resume_qualdescription'] = 'Qualification description';
$string['resume_files'] = 'Attachments';
$string['resume_employer'] = 'Employer';
$string['resume_employeraddress'] = 'Employer address';
$string['resume_jobtitle'] = 'Job title';
$string['resume_position'] = 'Position';
$string['resume_positiondescription'] = 'Position description';
$string['resume_certif'] = 'certifications, accreditations and awards';
$string['resume_date'] = 'Date';
$string['resume_title'] = 'Title';
$string['resume_description'] = 'description';
$string['resume_certifsaved'] = 'Certification, accreditation or award saved';
$string['resume_deletecertifconfirm'] = 'Do you really want to delete this certification, accreditation or award?';
$string['resume_certifdeleted'] = 'Certification, accreditation or award deleted';
$string['resume_public'] = 'Books and publications';
$string['resume_contribution'] = 'Contribution';
$string['resume_contributiondetails'] = 'Details of your contribution';
$string['resume_url'] = 'URL';
$string['resume_publicsaved'] = 'Books and publications saved';
$string['resume_deletepublicconfirm'] = 'Do you really want to delete this book or publication?';
$string['resume_publicdeleted'] = 'Book or publication deleted';
$string['resume_mbrship'] = 'Memberships';
$string['resume_mbrshipsaved'] = 'Membership saved';
$string['resume_deletembrshipconfirm'] = 'Do you really want to delete this membership?';
$string['resume_mbrshipdeleted'] = 'Membership deleted';
$string['resume_linkedin'] = 'LinkedIn profile';
$string['resume_linkedinsaved'] = 'LinkedIn profile saved';
$string['resume_deletelinkedinconfirm'] = 'Do you really want to delete this membership?';
$string['resume_linkedindeleted'] = 'LinkedIN profile deleted';
$string['resume_mygoals'] = 'My goals';
$string['resume_goals'] = 'Goals';
$string['resume_goalspersonal'] = 'Personal goals';
$string['resume_goalsacademic'] = 'Academic goals';
$string['resume_goalscareers'] = 'Career goals';
$string['resume_goalspersonalsaved'] = 'Personal goals saved';
$string['resume_goalsacademicsaved'] = 'Academic goals saved';
$string['resume_goalscareerssaved'] = 'Careers goals saved';
$string['resume_myskills'] = 'My skills';
$string['resume_skills'] = 'Skills';
$string['resume_skillspersonal'] = 'Personal skills';
$string['resume_skillsacademic'] = 'Academic skills';
$string['resume_skillscareers'] = 'Career skills';
$string['resume_skillspersonalsaved'] = 'Personal skills saved';
$string['resume_skillsacademicsaved'] = 'Academic skills saved';
$string['resume_skillscareerssaved'] = 'Careers skills saved';
$string['resume_goalscomp'] = 'Educational standards';
$string['resume_skillscomp'] = 'Educational standards';
$string['resume_badges'] = 'Badges';
$string['resume_exportto_europass'] = 'Export to Europass';
$string['resume_exportto_europass_intro'] = '<p>The Europass profile can help people to plan their learning and career development. The profile can be used by organisations – employers, volunteer organisations, recruiters, guidance practitioners, youth organisations, education and training institutions and more – as part of the support and services they offer to people.</p>
        <p>We provide a way for using your CV from Exabis eProtfolio in Europass profile<br>
            The generated XML-file has to be inserted into the page <a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang=en" target="_blank">Create your CV</a><br>
            (better to be logged in in the Europass previously)<br>
            Press the button "Import Europass CV" and upload XML-file wich will genareted the button below
        </p>

    Some notes:<br>
    <ul>
        <li>You definitely need to check out the resulting CV</li>
        <li>Your personal data will be taken from your Moodle account</li>
        <li>Please check all dates, telephones, addresses</li>
        <li>Images from the HTML-editors will not be exported</li>
        <li>Most texts from the HTML-editors need to be reformatted</li>
        <li>Attached files are not implemented in new version of Europass, so they will not be imported</li>
    </ul>';
$string['resume_exportto_europass_getXML'] = 'Download XML';
$string['resume_expand'] = 'Expand all';
$string['resume_collaps'] = 'Collaps all';

// === Structure sharing.
$string['shared_categories'] = 'Shared Categories';
$string['nothingstructureshared'] = 'Nobody is sharing a structure with you';
$string['browsecategory'] = 'Browse this category';
$string['copycategory'] = 'Copy to my Portfolio';
$string['sharedArtefacts'] = 'Group portfolios shared with you';
$string['shareditems_category'] = 'Group portfolios shared with you';
$string['create_as_note'] = 'Create as Artefact';
$string['category_not_found'] = 'Category not found';
$string['root_category'] = 'Root Category';
$string['current_category'] = 'Current Category';
$string['change_layout'] = 'Change Layout';
$string['details'] = 'Details';
$string['tiles'] = 'Tiles';
$string['category_up'] = 'back to Parent Category';
$string['supported'] = 'supported by';
$string['developed'] = 'developed by';
$string['myfilearea'] = 'My file area';
$string['show_mystudents'] = 'My students';
$string['show_sharedbyuser'] = 'Shared by users';
$string['enrolled_courses'] = 'Related with courses';
$string['browseportfolio'] = 'Browse this portfolio';

// === Language categories.
$string['lang_categories'] = '';

// === Message.
$string['messageprovider:sharing'] = 'Sharing notifications';

// === Not Used Anymore.
$string['i_shared'] = 'I shared an eportfolio view with you';
$string['addstdcat'] = 'import standard categories';
$string['incompatible_video'] = 'To view this video please use the direct link: {$a->link}';
$string['download_pdf'] = 'Download as Pdf';
$string['pdf_settings'] = 'Pdf settings';
$string['pdf_settings_description'] = 'If you use some special or uncommon language characters the generated pdf can have problems. So, you can try to use different font settings<br>
            Your PDF settings will be saved for this view.<br>So, if your view is shared with other users - they will see the pdf with your settings.<br>
            Non-standard fonts can have some lost options like bold, italic, e.t.c.';
$string['pdf_settings_fontfamily'] = 'Font family';
$string['pdf_settings_fontsize'] = 'Basic font size';
$string['pdf_settings_showmetadata'] = 'Add view meta data';
$string['pdf_settings_showusername'] = 'user name';
$string['pdf_settings_showuserpicture'] = 'user picture';
$string['pdf_settings_showuseremail'] = 'user email';
$string['pdf_settings_showuserphone'] = 'user phone';
$string['pdf_customfont'] = 'Upload custom font';
$string['pdf_settings_uploadfont'] = 'Upload self font';
$string['pdf_settings_pagesize'] = 'Page size';
$string['pdf_settings_pageorient'] = 'Page orientation';
$string['pdf_settings_pageorient.portrait'] = 'Portrait';
$string['pdf_settings_pageorient.landscape'] = 'Landscape';
$string['pdf_customfont_help'] = 'Your can upload own .ttf file. We will try to use it for PDF generation.';
$string['pdf_settings_fontfamily_fixedgroup'] = 'Predefined fonts';
$string['pdf_settings_fontfamily_customgroup'] = 'Custom uploaded fonts';
$string['selected_competencies'] = 'Achieved Competency';
$string['forms.item.title'] = 'Title';
$string['forms.item.title_help'] = 'Title help text';
$string['view_saved'] = 'View saved';
$string['view_sharing_updated'] = 'View sharing updated';
$string['list'] = 'List';
$string['what_is_embed_code_title'] = 'What is embed code?';
$string['what_is_embed_code_content'] = '<p>Embed code is code that is generated by a third-party website such as YouTube or Twitter, that a user can copy and paste into his or her own webpage.  This embedded code will then show the same media, application, or feed on the user\'s web page as it does in the original source.</p>
            <p>We provide instructions for the most popular video vendors such as YouTube or Vimeo.</p>
            <p><strong>Finding the embed code on YouTube:</strong></p>
            <ol>
                <li>Go to YouTube</a>.</li>
                <li>Navigate to the video you wish to embed.</li>
                <li>Click the <strong>Share link</strong> below the video, then click the <strong>Embed link</strong>.</li>
                <li>Press <strong>Copy</strong> button in the footer of opened window.</li>
                <li>The embed link will be highlighted in blue and copied to the clipboard.</li>
                <li>Past the code to exabis E-portfolio textarea field.</li>
            </ol>
            <p><strong>Finding the embed code on Vimeo:</strong></p>
            <ol>
                <li>Go to Vimeo.</li>
                <li>Navigate to the video you wish to embed.</li>
                <li>Click the <strong>Share</strong> button, in the top right corner of your video.</li>
                <li>A pop-up will appear with the embed link information. You will need to copy only the <strong>&lt;<i>iframe</i>&gt;</strong> portion of the embed link.
                    Example:<br>                    
                    <ol>
                        <li>
                            Entire embed link shows the following:<br>
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Automation Opening[2]&lt;/a&gt; from &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; on &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea>                            
                        </li>
                        <li>
                            You only need to copy the <strong>&lt;<i>iframe</i>&gt;</strong> portion:<br>                            
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;</textarea>                            
                        </li>                    
                    </ol>
                <li>Past this code to exabis E-portfolio textarea field.</li>
            </ol>
            ';

// === Privacy wordings
$string['privacy:metadata:block_exaportuser'] = 'user\'s data from exabis e-portfolio';
$string['privacy:metadata:block_exaportuser:user_id'] = 'user id';
$string['privacy:metadata:block_exaportuser:description'] = 'description';
$string['privacy:metadata:block_exaportuser:view_items_layout'] = 'user id';
$string['privacy:metadata:block_exaportcate'] = 'user\'s categories';
$string['privacy:metadata:block_exaportcate:pid'] = 'parent category id';
$string['privacy:metadata:block_exaportcate:userid'] = 'user id';
$string['privacy:metadata:block_exaportcate:name'] = 'title';
$string['privacy:metadata:block_exaportcate:timemodified'] = 'last modified';
$string['privacy:metadata:block_exaportcate:courseid'] = 'course id';
$string['privacy:metadata:block_exaportcate:description'] = 'description';
$string['privacy:metadata:block_exaportcate:subjid'] = 'related subject id';
$string['privacy:metadata:block_exaportcate:topicid'] = 'related topic id';
$string['privacy:metadata:block_exaportcate:source'] = 'source';
$string['privacy:metadata:block_exaportcate:sourceid'] = 'source id';
$string['privacy:metadata:block_exaportcate:parent_ids'] = 'list of parent ids';
$string['privacy:metadata:block_exaportcate:parent_titles'] = 'list of parent titles';
$string['privacy:metadata:block_exaportcate:stid'] = 'schooltype id';
$string['privacy:metadata:block_exaportcate:sourcemod'] = 'sourcemod';
$string['privacy:metadata:block_exaportcate:name_short'] = 'short title';
$string['privacy:metadata:block_exaportcate:shareall'] = 'shared for all? 0 - did not share; 1 - shared for all; 2 - shared for groups';
$string['privacy:metadata:block_exaportcate:internshare'] = 'internal share?';
$string['privacy:metadata:block_exaportcate:structure_shareall'] = 'shared as structure? : 0 - did not share; 1 - shared for all; 2 - shared for groups';
$string['privacy:metadata:block_exaportcate:structure_share'] = 'shared as structure? look also \'structure_shareall\'';
$string['privacy:metadata:block_exaportitem'] = 'user\'s artifact';
$string['privacy:metadata:block_exaportitem:userid'] = 'artifact\'s owner';
$string['privacy:metadata:block_exaportitem:type'] = 'type of artifact';
$string['privacy:metadata:block_exaportitem:categoryid'] = 'category id';
$string['privacy:metadata:block_exaportitem:name'] = 'name';
$string['privacy:metadata:block_exaportitem:url'] = 'url';
$string['privacy:metadata:block_exaportitem:intro'] = 'intro';
$string['privacy:metadata:block_exaportitem:timemodified'] = 'last modified time';
$string['privacy:metadata:block_exaportitem:courseid'] = 'course id';
$string['privacy:metadata:block_exaportitem:shareall'] = 'shared for all?';
$string['privacy:metadata:block_exaportitem:externaccess'] = 'external access?';
$string['privacy:metadata:block_exaportitem:externcomment'] = 'comment for externals';
$string['privacy:metadata:block_exaportitem:fileurl'] = 'url to file';
$string['privacy:metadata:block_exaportitem:exampid'] = 'related example id';
$string['privacy:metadata:block_exaportitem:langid'] = 'language id';
$string['privacy:metadata:block_exaportitem:source'] = 'source';
$string['privacy:metadata:block_exaportitem:sourceid'] = 'source id';
$string['privacy:metadata:block_exaportitem:iseditable'] = 'is editable?';
$string['privacy:metadata:block_exaportitem:example_url'] = 'artifact\'s owner';
$string['privacy:metadata:block_exaportitem:parentid'] = 'parent id';
$string['privacy:metadata:block_exaportitemcomm'] = 'comments for artifacts';
$string['privacy:metadata:block_exaportitemcomm:itemid'] = 'id of artifact';
$string['privacy:metadata:block_exaportitemcomm:userid'] = 'author of comment';
$string['privacy:metadata:block_exaportitemcomm:entry'] = 'comment';
$string['privacy:metadata:block_exaportitemcomm:timemodified'] = 'last modified';
$string['privacy:metadata:block_exaportview'] = 'comments for artifacts';
$string['privacy:metadata:block_exaportview:userid'] = 'owner of view';
$string['privacy:metadata:block_exaportview:name'] = 'name';
$string['privacy:metadata:block_exaportview:description'] = 'description';
$string['privacy:metadata:block_exaportview:timemodified'] = 'last modified';
$string['privacy:metadata:block_exaportview:shareall'] = 'shared for all?';
$string['privacy:metadata:block_exaportview:externaccess'] = 'external access?';
$string['privacy:metadata:block_exaportview:externcomment'] = 'comment from external?';
$string['privacy:metadata:block_exaportview:langid'] = 'language id';
$string['privacy:metadata:block_exaportview:layout'] = 'layout of the view';
$string['privacy:metadata:block_exaportview:sharedemails'] = 'shared emails list';
$string['privacy:metadata:block_exaportview:autofill_artefacts'] = 'enabled autofill by artifacts';
$string['privacy:metadata:block_exaportresume'] = 'resume data';
$string['privacy:metadata:block_exaportresume:user_id'] = 'resume owner';
$string['privacy:metadata:block_exaportresume:courseid'] = 'course id';
$string['privacy:metadata:block_exaportresume:cover'] = 'cover content';
$string['privacy:metadata:block_exaportresume:interests'] = 'interests';
$string['privacy:metadata:block_exaportresume:goalspersonal'] = 'personal goals';
$string['privacy:metadata:block_exaportresume:goalsacademic'] = 'academic goals';
$string['privacy:metadata:block_exaportresume:goalscareers'] = 'careers goals';
$string['privacy:metadata:block_exaportresume:skillspersonal'] = 'personal skills';
$string['privacy:metadata:block_exaportresume:skillsacademic'] = 'academic skills';
$string['privacy:metadata:block_exaportresume:skillscareers'] = 'careers skills';
$string['privacy:metadata:core_files'] = 'Exabis ePortfolio stores files which have been uploaded by the user to form part of artifacts, resume entries and comments.';
