
<?php $__env->startSection('title', sprintf('%s - %s', __('messages.edit_sub_system_subjects'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

            <?php echo $__env->make("admin.response.global", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.edit_sub_system_subjects")); ?></div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">

                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate action="<?php echo e(route("subject.update-SubSystem-subject")); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <div class="col-md-12">
                                                <label for="validationCustom04" class="form-label"><?php echo e(__("messages.sub_systems")); ?></label>
                                                <select class="form-select" id="sub_system_id" name="sub_system_id" required> <option selected disabled value=""><?php echo e(__("messages.select")); ?></option>
                                                    <?php $__currentLoopData = $subSystems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSystem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($subSystem->{"id"}); ?>"
                                                       <?php if($subSystem->{"id"} == $currentSubsystem->{"id"}): ?> selected <?php endif; ?>
                                                        ><?php echo e($subSystem->{"designation"}); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div>
                                                <h6 class="mb-0"><?php echo e(__("messages.subjects")); ?></h6>
                                                <div class="card-body">
                                                    <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="form-check">
                                                            <label class="form-check-label" for="flexCheckChecked"> <input class="form-check-input" type="checkbox" name="subjectIds[]" value="<?php echo $subject->{"id"} ?>"
                                                                <?php $__currentLoopData = $currentSubsystem->{"subjects"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selectedSubjects): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo e(($selectedSubjects->{"id"} == $subject->{"id"} ? 'checked' : '')); ?>

                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                > <?php echo $subject->{"designation"} ?> </label>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit"><?php echo e(__("messages.save")); ?></button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered" style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th><?php echo e(__("messages.sub_system")); ?></th>
                                                <th><?php echo e(__("messages.subjects")); ?></th>
                                                <th><?php echo e(__("messages.action")); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $subSystems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSystem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo $subSystem->{"id"} ?></td>
                                                    <td><?php echo $subSystem->{"designation"} ?></td>
                                                    <td>
                                                        <?php $__currentLoopData = $subSystem->{"subjects"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php   echo "<div>" .$subject->{"designation"} . "</div>" ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="<?php echo e(route("subject.edit-subSystem-subject", $subSystem->{"id"})); ?>" class="bx bxs-pencil" title="<?php echo e(__("messages.edit")); ?>"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-sub_system_id="<?php echo e($subSystem->{"id"}); ?>" data-sub_system_name="<?php echo e($subSystem->{"designation"}); ?>"  title="<?php echo e(__("messages.delete")); ?>"></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end row-->
                </div>
            </div>

            <?php echo $__env->make("admin.subject.sub_system.delete_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script>
        $(document).ready(function() {
            let currentSubSystemId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentSubSystemId = $(this).data('sub_system_id');
                let sub_system_name = $(this).data('sub_system_name');
                $("#sub_system_name").html(sub_system_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentSubSystemId !== null) {
                    $.ajax({
                        url: "<?php echo e(route("subject.delete-subSystem-subject")); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentSubSystemId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "<?php echo e(route("subject.subSystem-subjects")); ?>";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        } );
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/admin/subject/sub_system/edit.blade.php ENDPATH**/ ?>