<?php $__env->startSection('title', sprintf('%s - %s', __('messages.class_subjects'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

            <?php echo $__env->make("admin.response.global", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.add_class_subjects")); ?></div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate action="<?php echo e(route("subject.update-class-subject")); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" value="<?php echo e($subjectGroup->{"id"}); ?>" name="subject_group_id" id="subject_group_id">
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label"><?php echo e(__("messages.subject_group")); ?></label>
                                                <input type="text" value="<?php echo e($subjectGroup->{'designation'}); ?>" name="designation" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationCustom04" class="form-label"><?php echo e(__("messages.sub_systems")); ?></label>
                                                <select class="form-select" id="sub_system" name="sub_system" required> <option selected disabled value=""><?php echo e(__("messages.select")); ?></option>
                                                    <?php $__currentLoopData = $subSystems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSystem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($subSystem->{"id"}); ?>"
                                                        <?php if($subSystem->{'id'} == $subjectGroup->{"subjectGroupClass"}->{"subSystem"}->{"id"}): ?>
                                                            <?php echo e("selected"); ?>

                                                            <?php endif; ?>
                                                        ><?php echo e($subSystem->{"designation"}); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.education_type")); ?></label>
                                                <select class="form-select" id="education_type" name="education_type" required aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>
                                          <div class="col-md-12" id="classInput">
                                          <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label>
                                          <select class="form-select" id="class_id" name="class_id"  aria-label="select example">
                                          </select>
                                         <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                          </div>

                                            <div class="col-md-12" id="subEducationTypeInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.sub_education_type")); ?></label>
                                                <select class="form-select" id="sub_education_type" name="sub_education_type"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="specialtyInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.specialty")); ?></label>
                                                <select class="form-select" id="specialty" name="specialty"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="specialtyClassInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label>
                                                <select class="form-select" id="specialty_class" name="specialty_class"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="levelInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.level")); ?></label>
                                                <select class="form-select" id="level" name="level"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="levelClassInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label>
                                                <select class="form-select" id="level_class" name="level_class"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <h6 class="mb-0"><?php echo e(__("messages.subjects")); ?></h6>
                                            <div class="col-md-12">
                                                <div class="col-md-12 subject_checkbox">
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit"><?php echo e(__("messages.save")); ?></button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered" style="width:100%">
                                            <thead>
                                            <tr>
                                                <th><?php echo e(__("messages.subject_group")); ?></th>
                                                <th><?php echo e(__("messages.sub_systems")); ?></th>
                                                <th><?php echo e(__("messages.education_type")); ?></th>
                                                <th><?php echo e(__("messages.subject")); ?></th>
                                                <th><?php echo e(__("messages.action")); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $subjectGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classSubject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo $classSubject->{"designation"} ?></td>
                                                    <td><?php echo $classSubject->{"subjectGroupClass"}->{"subSystem"}->{"designation"} ?></td>
                                                    <td><?php echo $classSubject->{"subjectGroupClass"}->{"educationType"}->{"designation"} ?></td>








                                                    <td>
                                                        <?php $__currentLoopData = $classSubject->{"subjectGroupSubjects"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subjectGroupSubject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php   echo "<div>" .$subjectGroupSubject->{"designation"} . "</div>" ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="<?php echo e(route("subject.edit-class-subject", $classSubject->{"id"})); ?>" class="bx bxs-pencil" title="<?php echo e(__("messages.edit")); ?>"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-class_subject_id="<?php echo e($classSubject->{"id"}); ?>" data-class_subject_name="<?php echo e($classSubject->{"designation"}); ?>"  title="<?php echo e(__("messages.delete")); ?>"></a>
                                                        </div>
                                                    </td>

                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end row-->
                </div>
            </div>

            <?php echo $__env->make("admin.subject.class.delete_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script>
        $(document).ready(function() {
            let currentClassSubjectId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentClassSubjectId = $(this).data('class_subject_id');
                let class_subject_name = $(this).data('class_subject_name');
                $("#class_subject_name").html(class_subject_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentClassSubjectId !== null) {
                    $.ajax({
                        url: "<?php echo e(route("subject.delete-class-subject")); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentClassSubjectId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "<?php echo e(route("subject.class-subject")); ?>";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

            const sub_system_id = $('#sub_system').val();
            const subject_group_id  = <?php echo $subjectGroup->{"id"} ?>;
            const education_type_id = <?php echo $subjectGroup->{"subjectGroupClass"}->{"educationType"}->{"id"}  ?>;
            const class_id = <?php echo $subjectGroup->{"subjectGroupClass"}->{"educationTypeClass"} != null ? $subjectGroup->{"subjectGroupClass"}->{"educationTypeClass"}->{"classes"}->{"id"} : 0; ?>;

            const sub_education_type_id = <?php echo $subjectGroup->{"subjectGroupClass"}->{"sub_education_type_id"} != 0 ? $subjectGroup->{"subjectGroupClass"}->{"subEducationType"}->{"id"} : 0 ?>;
            const specialty_id = <?php echo $subjectGroup->{"subjectGroupClass"}->{"specialtyClass"} != null ? $subjectGroup->{"subjectGroupClass"}->{"specialtyClass"}->{"specialty"}->{"id"} : 0 ?>;
            const specialty_class_id = <?php echo $subjectGroup->{"subjectGroupClass"}->{"specialtyClass"} != null ? $subjectGroup->{"subjectGroupClass"}->{"specialtyClass"}->{"classes"}->{"id"} : 0 ?>;

            const level_id = <?php echo $subjectGroup->{"subjectGroupClass"}->{"levelClass"} != null ? $subjectGroup->{"subjectGroupClass"}->{"levelClass"}->{"level"}->{"id"} : 0 ?>;
            const level_class_id = <?php echo $subjectGroup->{"subjectGroupClass"}->{"levelClass"} != null ? $subjectGroup->{"subjectGroupClass"}->{"levelClass"}->{"classes"}->{"id"} : 0 ?>;

            getEducationType(sub_system_id, education_type_id, 'education_type')

            if(class_id !== 0) {
                getClass(education_type_id, class_id, 'class_id')
            }

            if(sub_education_type_id !== 0) {
                getSubEducationType(education_type_id, sub_education_type_id, 'sub_education_type')
                getSubEducationTypSpecialty(sub_education_type_id, specialty_id, 'specialty')
                getSpecialtyClass(specialty_id, specialty_class_id, 'specialty_class')
            }

            if(level_id !== 0) {
                getLevels(education_type_id, level_id, 'level')
                getLevelClass(level_id, level_class_id, 'level_class')
            }

            $(document).on('change', '#sub_system', function (e) {
                getEducationType(sub_system_id, education_type_id, 'education_type')
            });

            $(document).on('change', '#education_type', function (e) {
                $('#class_id').html("");
                var educationTypeId = $(this).val();
                function processInput(educationTypeId) {
                    var output = [];
                    var json = educationTypeId.split(' '); // Split text by spaces into array

                    json.forEach(function (item) { // Loop through each array item
                        var out = item.replace(/\'/g,''); // Remove all single quote '  from chunk
                        out = out.split(/(\d+)/); // Now again split the chunk by Digits into array
                        out = out.filter(Boolean); // With Boolean we can filter out False Boolean Values like -> false, null, 0
                        output.push(out);
                    });

                    return output;
                }

                var outputId = processInput(educationTypeId[0]);
                var outputType = processInput(educationTypeId[1]);


                if (outputType == "G") {
                    getClass(outputId, 0, 'class_id');
                }

                if (outputType == "T") {
                    getSubEducationType(outputId, 0, sub_education_type_id) ;
                }

                if (outputType == "E") {
                    getLevels(outputId, 0, level_id)
                }
            })

            $(document).on('change', '#sub_education_type', function (e) {
                getSubEducationTypSpecialty(sub_education_type_id, specialty_id, 'specialty')
            });

            $(document).on('change', '#specialty', function (e) {
                getSpecialtyClass(specialty_id, specialty_class_id, 'specialty_class')
            })

            function getEducationType(sub_system_id, education_type_id, select_control) {
                if(sub_system_id !== ""){
                    $('#' + select_control).html("");
                    var div_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('education-type.get')); ?>?sub_system_id=" + sub_system_id,
                        success: function(data) {
                            if(data) {
                                $("#education_type").empty();
                                $.each(data, function(key, value) {
                                    var sel = "";
                                    if (education_type_id === value.id) {
                                        sel = "selected";
                                    }
                                    div_data += "<option value=" + value.id + value.type + " " + sel + ">" + value.designation + "</option>";
                                });
                            } else  {
                                $("#education_type").empty();
                            }
                            $('#' + select_control).append(div_data);
                        },
                    });

                    var response_data = "";
                    $.ajax({
                        url: "<?php echo e(route('subject.get-selected-sub-system-subjects')); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            sub_system_id: sub_system_id,
                            subject_group_id: subject_group_id,
                        },
                        success: function(data) {
                            if (data) {
                                $.each(data.subjects, function (key, value)
                                {
                                    var check = "";
                                    var selectedSubjectIds = [];

                                    $.each(data.selectedSubjects, function(key, value) {
                                        selectedSubjectIds.push(parseInt(value.id));
                                    });

                                    if (jQuery.inArray(value.id, selectedSubjectIds) !== -1) {
                                        check = "checked";
                                    }

                                    response_data += "<div class='form-check'>";
                                    response_data += "<label>";
                                    response_data += "<input type='checkbox' class='form-check-input' name='subjectIds[]' value='" + value.id + "' " + check + ">" + value.designation;
                                    response_data += "</label>";
                                    response_data += "</div>";
                                });
                                $('.subject_checkbox').html(response_data);
                            }
                        }
                    });
                }
            }

            function getClass(education_type_id, class_id, select_control) {
                if(education_type_id !== ""){
                    $('#' + select_control).html("");
                    var div_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('class.get')); ?>?education_type_id=" + education_type_id,
                        success: function(data) {
                            if(data) {
                                $('#classInput').css('display', 'block');
                                $('#subEducationTypeInput').css('display', 'none');
                                $('#specialtyInput').css('display', 'none');
                                $('#specialtyClassInput').css('display', 'none');
                                $('#levelInput').css('display', 'none');
                                $('#levelClassInput').css('display', 'none');

                                $("#class_id").empty();
                                $.each(data, function(key, value) {
                                    var sel = "";
                                    if (class_id === value.id) {
                                        sel = "selected";
                                    }
                                    div_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                });
                            } else  {
                                $("#class_id").empty();
                            }
                            $('#' + select_control).append(div_data);
                        },
                    });
                }
            }

            function getSubEducationType(education_type_id, sub_education_type_id, select_control) {
                if(education_type_id !== ""){
                    $('#' + select_control).html("");
                    var div_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('sub-education-type.get')); ?>?education_type_id=" + education_type_id,
                        success: function(data) {
                            if(data) {
                                $('#classInput').css('display', 'none');
                                $('#levelInput').css('display', 'none');
                                $('#levelClassInput').css('display', 'none');
                                $('#subEducationTypeInput').css('display', 'block');
                                $('#specialtyInput').css('display', 'block');
                                $('#specialtyClassInput').css('display', 'block');

                                $("#sub_education_type").empty();
                                $.each(data, function(key, value) {
                                    var sel = "";
                                    if (sub_education_type_id === value.id) {
                                        sel = "selected";
                                    }
                                    div_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                });
                            } else  {
                                $("#sub_education_type").empty();
                            }
                            $('#' + select_control).append(div_data);
                        },
                    });
                }
            }

            function getSubEducationTypSpecialty(sub_education_type_id, specialty_id, select_control) {
                if(sub_education_type_id !== ""){
                    $('#' + select_control).html("");
                    var div_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('specialty.get')); ?>?sub_education_type_id=" + sub_education_type_id,
                        success: function(data) {
                            if(data) {
                                $("#specialty").empty();
                                $.each(data, function(key, value) {
                                    var sel = "";
                                    if (specialty_id === value.id) {
                                        sel = "selected";
                                    }
                                    div_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                });
                            } else  {
                                $("#specialty").empty();
                            }
                            $('#' + select_control).append(div_data);
                        },
                    });
                }
            }

            function getSpecialtyClass(specialty_id, specialty_class_id, select_control) {
                if(specialty_id !== ""){
                    $('#' + select_control).html("");
                    var div_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('class.get-specialty-classes')); ?>?specialty_id=" + specialty_id,
                        success: function(data) {
                            if(data) {
                                $("#specialty_class").empty();
                                $.each(data, function(key, value) {
                                    var sel = "";
                                    if (specialty_class_id === value.id) {
                                        sel = "selected";
                                    }
                                    div_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                });
                            } else  {
                                $("#specialty_class").empty();
                            }
                            $('#' + select_control).append(div_data);
                        },
                    });
                }
            }

            function getLevels(education_type_id, level_id, select_control) {
                if(education_type_id !== ""){
                    $('#' + select_control).html("");
                    var div_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('levels.get')); ?>?education_type_id=" + education_type_id,
                        success: function(data) {
                            if(data) {
                                $('#classInput').css('display', 'none');
                                $('#subEducationTypeInput').css('display', 'none');
                                $('#specialtyInput').css('display', 'none');
                                $('#specialtyClassInput').css('display', 'none');
                                $('#levelInput').css('display', 'block');
                                $('#levelClassInput').css('display', 'block');

                                $("#level").empty();
                                $.each(data, function(key, value) {
                                    var sel = "";
                                    if (level_id === value.id) {
                                        sel = "selected";
                                    }
                                    div_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                });
                            } else  {
                                $("#level").empty();
                            }
                            $('#' + select_control).append(div_data);
                        },
                    });
                }
            }

            function  getLevelClass(level_id, level_class_id, select_control) {
                if(level_id !== ""){
                    $('#' + select_control).html("");
                    var div_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('level-classes.get')); ?>?level_id=" + level_id,
                        success: function(data) {
                            if(data) {
                                $("#level_class").empty();
                                $.each(data, function(key, value) {
                                    var sel = "";
                                    if (level_class_id === value.id) {
                                        sel = "selected";
                                    }
                                    div_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                });
                            } else  {
                                $("#level_class").empty();
                            }
                            $('#' + select_control).append(div_data);
                        },
                    });
                }
            }

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        } );
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/admin/subject/class/edit.blade.php ENDPATH**/ ?>