<?php

namespace App\RequestRules\Web;

class RevisionRules
{

    /**
     * Create revision rules
     *
     * @return array
     */
    public static function create(): array
    {
        return [
            "sub_system" => "required|integer|exists:sub_systems,id",
            'exam' => 'required|string|max:255',
            "subject_id" => "required|integer|exists:subjects,id",
            'topic' => 'nullable|string|max:255',
            'link' => 'required|string|max:255',
            'studio' => 'required|string|max:255',
            'start_time' => ['required', 'date_format:' . config('minesec.constants.default_time_format')],
            'end_time' => ['required', 'date_format:' . config('minesec.constants.default_time_format')],
            'date' => ['required', 'date', 'date_format:' . config('minesec.constants.default_date_format')],
        ];
    }


    /**
     * Edit rules
     *
     * @param $id
     * @return string[]
     */
    public static function edit($id): array
    {
        return [
            "id" => "required|integer|exists:revisions",
        ];
    }

    /**
     * Update rules
     *
     * @return array
     */
    public static function update() {
        return [
            "revision_id" => "required|integer|exists:revisions,id",
            "sub_system" => "required|integer|exists:sub_systems,id",
            'exam' => 'required|string|max:255',
            "subject_id" => "required|integer|exists:subjects,id",
            'topic' => 'nullable|string|max:255',
            'link' => 'required|string|max:255',
            'studio' => 'required|string|max:255',
            'start_time' => ['required', 'date_format:' . config('minesec.constants.default_time_format')],
            'end_time' => ['required', 'date_format:' . config('minesec.constants.default_time_format')],
            'date' => ['required', 'date', 'date_format:' . config('minesec.constants.default_date_format')],
        ];
    }

    /**
     * Delete rules
     * @return string[]
     */
    public static function delete(): array
    {
        return [
            "id" => "required|integer|exists:revisions",
        ];
    }

}
