<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class LessonProgressionRules
{
    /**
     * Submit general education lesson rules
     *
     * @return string[]
     */
    #[ArrayShape(['lesson_title' => "string", 'lesson_description' => "string", 'lesson_power_point' => "string", "sub_system_id" => "string", "classIds" => "string", "subjectIds" => "string", "inspectorate_id" => "string"])] public static function submitGeneralEducationLesson(): array
    {
        return [
            'lesson_title' => 'required|string|max:255',
            'lesson_description' => 'required|string|max:255',
//            'lesson_power_point' => 'required|file|mimes:.pptx,',
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "classIds" => "required|array|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
            "inspectorate_id" => "required|integer|exists:inspectorates,id",
        ];
    }

    /**
     * Submit technical education lesson rules
     *
     * @return string[]
     */
    #[ArrayShape(['lesson_title' => "string", 'lesson_description' => "string", 'lesson_power_point' => "string", "sub_system_id" => "string", "sub_education_type_id" => "string", "specialty_id" => "string", "specialtyClassIds" => "string", "subjectIds" => "string", "inspectorate_id" => "string"])] public static function submitTechnicalEducationLesson(): array
    {
        return [
            'lesson_title' => 'required|string|max:255',
            'lesson_description' => 'required|string|max:255',
//            'lesson_power_point' => 'required|file|mimes:.pptx,',
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialtyClassIds" => "required|array|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
            "inspectorate_id" => "required|integer|exists:inspectorates,id",
        ];
    }

    /**
     * Submit teacher training lesson rules
     *
     * @return string[]
     */
    #[ArrayShape(['lesson_title' => "string", 'lesson_description' => "string", "sub_system_id" => "string", "level_id" => "string", "leveClassIds" => "string", "subjectIds" => "string", "inspectorate_id" => "string"])] public static function submitTeacherTrainingLesson(): array
    {
        return [
            'lesson_title' => 'required|string|max:255',
            'lesson_description' => 'required|string|max:255',
//            'lesson_power_point' => 'required|file|mimes:.pptx,',
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "level_id" => "required|integer|exists:levels,id",
            "leveClassIds" => "required|array|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
            "inspectorate_id" => "required|integer|exists:inspectorates,id",
        ];
    }

    /**
     * Edit lesson
     *
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function editLesson($id): array
    {
        return [
            "id" => "required|integer|exists:lesson_progressions",
        ];
    }

    /**
     * Show lesson
     *
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function showLesson($id): array
    {
        return [
            "id" => "required|integer|exists:lesson_progressions",
        ];
    }

    /**
     * Lesson approving rules
     *
     * @return string[]
     */
    #[ArrayShape(["lesson_progression_id" => "string", "type" => "string", 'lesson_power_point' => "string"])] public static function approveLesson(): array
    {
        return [
            "lesson_progression_id" => "required|integer|exists:lesson_progressions,id",
            "type" => "required|string",
            'lesson_power_point' => 'required|file',
        ];
    }

    /**
     * Lesson rejection rules
     *
     * @return string[]
     */
    #[ArrayShape(["lesson_progression_id" => "string", "reason" => "string"])] public static function rejectLesson(): array
    {
        return [
            "lesson_progression_id" => "required|integer|exists:lesson_progressions,id",
            "reason" => "required|string",
        ];
    }

    /**
     * Approve validated lesson
     *
     * @return string[]
     */
    #[ArrayShape(["lesson_progression_id" => "string", "reason" => "string"])] public static function approveRejectLesson(): array
    {
        return [
            "lesson_progression_id" => "required|integer|exists:lesson_progressions,id",
            "reason" => "sometimes|string",
        ];
    }
}
