<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\EducationType;
use App\Models\Level;
use App\Models\Specialty;
use App\Models\SubEducationType;
use App\Models\SubSystem;
use App\RequestRules\Api\ClassRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ClassController extends Controller
{
    /**
     * Get all sub systems
     *
     * @return Application|ResponseFactory|Response
     */
    public function getSubsystems(): Response|Application|ResponseFactory
    {
        $subSystems = SubSystem::allSubSystems();

        if ($subSystems == null) {
            return api_response(150, 'No sub systems found');
        }

        $subSystemsArray = array();
        foreach ($subSystems as $subSystem) {
            $subSystemsArray[] = array(
                "id" => $subSystem->{"id"},
                "designation" => $subSystem->{"designation"},
            );
        }

        return api_response(100, 'ok', $subSystemsArray);
    }

    /**
     * Get education types
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function getEducationTypes(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ClassRules::getEducationTypes());

        $subSystem = SubSystem::findById($request->{"sub_system_id"});

        if ($subSystem == null) {
            return api_response(150, 'No education types found');
        }

        $educationTypes = array();
        foreach ($subSystem->{"educationTypes"} as $educationType) {
            $educationTypes[] = array(
                "id" => $educationType->{"id"},
                "type" => $educationType->{"type"},
                "designation" => $educationType->{"designation"}
            );
        }

        return api_response(100, 'ok', $educationTypes);
    }

    /**
     * Get sub education types
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function getSubEducationTypes(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ClassRules::getSubEducationTypes());

        $EducationType = EducationType::findById($request->{"education_type_id"});

        if ($EducationType == null) {
            return api_response(150, 'No sub education types found');
        }

        $subEducationTypes = array();
        foreach ($EducationType->{"subEducation"} as $subEducationType) {
            $subEducationTypes[] = array(
                "id" => $subEducationType->{"id"},
                "designation" => $subEducationType->{"designation"}
            );
        }

        return api_response(100, 'ok', $subEducationTypes);
    }

    /**
     * Get specialties
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function getSpecialties(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ClassRules::getSpecialties());

        $subEducationType = SubEducationType::findById($request->{"sub_education_type_id"});

        if ($subEducationType == null) {
            return api_response(150, 'No specialties found');
        }

        $specialties = array();
        foreach ($subEducationType->{"specialties"} as $specialty) {
            $specialties[] =array(
                "id" => $specialty->{"id"},
                "designation" => $specialty->{"designation"}
            );
        }

        return api_response(100, 'ok', $specialties);
    }

    /**
     * Get specialty classes
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public  function getSpecialtyClasses(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ClassRules::getSpecialtyClasses());

        $specialty = Specialty::findById($request->{"specialty_id"});

        if ($specialty == null) {
            return api_response(150, 'No specialties found');
        }

        $specialtyClasses = array();
        foreach ($specialty->{"classes"} as $specialtyClass) {
            $specialtyClasses[] = array(
                "id" => $specialtyClass->{"id"},
                "designation" => $specialtyClass->{"designation"}
            );
        }

        return api_response(100, 'ok', $specialtyClasses);
    }

    /**
     * Get levels
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function getLevels(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ClassRules::getLevels());

        $EducationType = EducationType::findById($request->{"education_type_id"});

        if ($EducationType == null) {
            return api_response(150, 'No levels found');
        }

        $levels = array();
        foreach ($EducationType->{"Levels"} as $level) {
            $levels[] =array(
                "id" => $level->{"id"},
                "designation" => $level->{"designation"}
            );
        }

        return api_response(100, 'ok', $levels);
    }

    /**
     * Get level classes
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public  function getLevelClasses(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ClassRules::getLevelClasses());

        $levels = Level::findById($request->{"level_id"});

        if ($levels == null) {
            return api_response(150, 'No classes found');
        }

        $levelClasses = array();
        foreach ($levels->{"classes"} as $levelClass) {
            $levelClasses[] = array(
                "id" => $levelClass->{"id"},
                "designation" => $levelClass->{"designation"}
            );
        }

        return api_response(100, 'ok', $levelClasses);
    }

    /**
     * Get classes
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function  getCLasses(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ClassRules::getClasses());

        $EducationType = EducationType::findById($request->{"education_type_id"});

        if ($EducationType == null) {
            return api_response(150, 'No classes found');
        }

        $classes = array();
        foreach ($EducationType->{"classes"} as $class) {
            $classes[] = array(
                "id" => $class->{"id"},
                "designation" => $class->{"designation"}
            );
        }

        return api_response(100, 'ok', $classes);
    }
}
