
<?php $__env->startSection('title', sprintf('%s - %s', __('messages.edit_education_type'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

        <?php echo $__env->make("admin.response.global", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.edit_education_type")); ?></div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">

                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate  action="<?php echo e(route("education-type.update")); ?>" method="POST">

                                            <input type="hidden" name="id" value="<?php echo e($educationType->{"id"}); ?>"/>
                                            <input type="hidden" name="type" value="<?php echo e($educationType->{"type"}); ?>"/>

                                            <?php echo csrf_field(); ?>
                                            <div class="col-md-12">
                                                <label for="validationCustom03"
                                                       class="form-label"><?php echo e(__("messages.education_type")); ?></label>
                                                <input type="text" value="<?php echo e($educationType->{"designation"}); ?>"
                                                       name="designation" class="form-control" id="validationCustom03"
                                                       required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>


                                            <?php if($educationType->{"type"} == config('minesec.education_type.technical')): ?>
                                            <div>
                                                <span id="subEducationTypeField">
                                                    <h6 class="mb-0"><?php echo e(__("messages.sub_education_type")); ?></h6>
                                                    <div class="card-body">
                                                    <?php $__currentLoopData = $subEducationTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subEducationType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="form-check">
                                                        <label class="form-check-label" for="flexCheckChecked"> <input
                                                                class="form-check-input" type="checkbox" id="flexCheckChecked"
                                                                name="subEducationTypeIds[]"
                                                                value="<?php echo $subEducationType->{"id"} ?>"
                                                                     <?php $__currentLoopData = $educationType->{"subEducation"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selectedSubEducationType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                         <?php echo e(($selectedSubEducationType->{"id"} == $subEducationType->{"id"} ? 'checked' : '')); ?>

                                                                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            > <?php echo $subEducationType->{"designation"} ?> </label>
                                                    </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                </span>
                                            </div>
                                            <?php endif; ?>

                                            <?php if($educationType->{"type"} == config('minesec.education_type.general')): ?>
                                            <div>
                                                <h6 class="mb-0"><?php echo e(__("messages.class")); ?></h6>
                                                <div class="card-body">
                                                    <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="form-check">
                                                            <label class="form-check-label" for="flexCheckChecked">
                                                                <input class="form-check-input" type="checkbox" id="flexCheckChecked" name="classIds[]"  value="<?php echo $class->{"id"} ?>"
                                                                       <?php $__currentLoopData = $educationType->{"classes"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selectedClasses): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                       <?php echo e(($selectedClasses->{"id"} == $class->{"id"} ? 'checked' : '')); ?>

                                                                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                > <?php echo $class->{"designation"} ?> </label>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </div>
                                            </div>
                                            <?php endif; ?>

                                            <?php if($educationType->{"type"} == config('minesec.education_type.teacher_training')): ?>
                                                <div>
                                                    <h6 class="mb-0"><?php echo e(__("messages.levels")); ?></h6>
                                                    <div class="card-body">
                                                        <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="form-check">
                                                                <label class="form-check-label" for="flexCheckChecked">
                                                                    <input class="form-check-input" type="checkbox" id="flexCheckChecked" name="levelIds[]"  value="<?php echo $level->{"id"} ?>"
                                                                    <?php $__currentLoopData = $educationType->{"levels"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selectedLevels): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php echo e(($selectedLevels->{"id"} == $level->{"id"} ? 'checked' : '')); ?>

                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    > <?php echo $level->{"designation"} ?> </label>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit"><?php echo e(__("messages.save")); ?></button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered"
                                               style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th><?php echo e(__("messages.education_type")); ?></th>
                                                <th><?php echo e(__("messages.class")); ?></th>
                                                <th><?php echo e(__("messages.action")); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $educationTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $educationType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo $educationType->{"id"} ?></td>
                                                    <td><?php echo $educationType->{"designation"} ?></td>

                                                    <?php if($educationType->{"type"}  == config('minesec.education_type.general')): ?>
                                                        <td>
                                                            <?php $__currentLoopData = $educationType->{"classes"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php   echo "<div>" . $class->{"designation"} . "</div>" ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                    <?php endif; ?>

                                                    <?php if($educationType->{"type"} == config('minesec.education_type.technical')): ?>
                                                        <td>
                                                            <?php $__currentLoopData = $educationType->{"subEducation"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subEducation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php   echo "<div>" . $subEducation->{"designation"} . "</div>" ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                    <?php endif; ?>

                                                    <?php if($educationType->{"type"} == config('minesec.education_type.teacher_training')): ?>
                                                        <td>
                                                            <?php $__currentLoopData = $educationType->{"levels"}; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php   echo "<div>" . $level->{"designation"} . "</div>" ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                    <?php endif; ?>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="<?php echo e(route("education-type.edit", $educationType->{"id"})); ?>" class="bx bxs-pencil" title="<?php echo e(__("messages.edit")); ?>"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-education_type_id="<?php echo e($educationType->{"id"}); ?>" data-education_type_name="<?php echo e($educationType->{"designation"}); ?>"  data-type="<?php echo e($educationType->{"type"}); ?>"  title="<?php echo e(__("messages.delete")); ?>"></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end row-->
                </div>
            </div>

        <?php echo $__env->make("admin.education_type.delete_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script>
        $(document).ready(function() {
            let currentEducationTypeId = null;
            let currentType = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentEducationTypeId = $(this).data('education_type_id');
                currentType = $(this).data('type');
                let education_type_name = $(this).data('education_type_name');
                $("#education_type_name").html(education_type_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentEducationTypeId !== null) {
                    $.ajax({
                        url: "<?php echo e(route("education-type.delete")); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentEducationTypeId,
                            type: currentType,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "<?php echo e(route("education-type.index")); ?>";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $('#example').DataTable();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/admin/education_type/edit.blade.php ENDPATH**/ ?>