<?php $__env->startSection('title', sprintf('%s - %s', __('messages.revision'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet"/>
    <link href="<?php echo e(asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet"/>
    <link href="<?php echo e(asset('assets/plugins/select2/css/select2-bootstrap4.css')); ?>" rel="stylesheet"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

        <?php echo $__env->make("admin.response.global", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.add_revision")); ?></div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate
                                              action="<?php echo e(route("revision.create")); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <div class="col-xl-4 col-md-4">
                                                <label for="sub_system"
                                                       class="form-label"><?php echo e(__("messages.sub_systems")); ?></label>
                                                <select class="form-select" id="sub_system" name="sub_system" required>
                                                    <option value=""><?php echo e(__("messages.select")); ?></option>
                                                    <?php $__currentLoopData = $subSystems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSystem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($subSystem->{"id"}); ?>"
                                                        <?php if($subSystem->{'id'} == old("sub_system")): ?>
                                                            <?php echo e("selected"); ?>

                                                            <?php endif; ?>
                                                        ><?php echo e($subSystem->{"designation"}); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label for="exam" class="form-label"><?php echo e(__("messages.exam")); ?></label>
                                                <select class="form-select" id="exam" name="exam" required>
                                                    <option value=""><?php echo e(__("messages.select")); ?></option>
                                                    <?php $__currentLoopData = $xamTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key); ?>"
                                                        <?php if($key == old("exam")): ?>
                                                            <?php echo e("selected"); ?>

                                                            <?php endif; ?>
                                                        ><?php echo e($value); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label class="form-label"><?php echo e(__("messages.subject")); ?></label>
                                                
                                                <select class="form-select" id="subject_id" name="subject_id" required>
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label for="validationCustom03"
                                                       class="form-label"><?php echo e(__("messages.topic")); ?></label>
                                                <input type="text" value="<?php echo e(old('topic')); ?>" id="topic" name="topic"
                                                       class="form-control">
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label class="form-label"><?php echo e(__("messages.link")); ?></label>
                                                <input type="url" value="<?php echo e(old('link')); ?>" name="link"
                                                       class="form-control" id="link" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label for="studio"
                                                       class="form-label"><?php echo e(__("messages.studio")); ?></label>
                                                <select class="form-select" id="studio" name="studio" required>
                                                    <option value=""><?php echo e(__("messages.select")); ?></option>
                                                    <?php $__currentLoopData = $studios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key); ?>"
                                                        <?php if($key == old("studio")): ?>
                                                            <?php echo e("selected"); ?>

                                                            <?php endif; ?>
                                                        ><?php echo e($value); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label class="form-label"><?php echo e(__("messages.start_time")); ?></label>
                                                <input type="time" value="<?php echo e(old("start_time")); ?>" name="start_time"
                                                       class="form-control" id="start_time" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label class="form-label"><?php echo e(__("messages.end_time")); ?></label>
                                                <input type="time" value="<?php echo e(old("end_time")); ?>" name="end_time"
                                                       class="form-control" id="end_time" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label class="form-label"><?php echo e(__("messages.date")); ?></label>
                                                <input type="date" value="<?php echo e(old("date")); ?>" name="date" id="date"
                                                       class="form-control" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right"
                                                        type="submit"><?php echo e(__("messages.save")); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered"
                                               style="width:100%">
                                            <thead>
                                            <tr>
                                                <th><?php echo e(__("messages.sub_systems")); ?></th>
                                                <th><?php echo e(__("messages.subject")); ?></th>
                                                <th><?php echo e(__("messages.link")); ?></th>
                                                <th><?php echo e(__("messages.studio")); ?></th>
                                                <th><?php echo e(__("messages.start_time")); ?></th>
                                                <th><?php echo e(__("messages.end_time")); ?></th>
                                                <th><?php echo e(__("messages.date")); ?></th>
                                                <th><?php echo e(__("messages.action")); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $revisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                $CurrentDateTime = \Illuminate\Support\Carbon::now();
                                                $CarbonEndTime = \Carbon\Carbon::parse($schedule->{"end_time"});
                                                ?>
                                                <tr>
                                                    <td><?php echo e($schedule->{"subSystem"}->{"designation"}); ?></td>
                                                    <td><?php echo e($schedule->{"subject"}->{"designation"}." (". $schedule->{"exam"}.")"); ?></td>
                                                    <?php if($CurrentDateTime->gt($CarbonEndTime)): ?>
                                                        <td style="width: 8px"><span class="badge bg-gradient-bloody text-white shadow-sm w-100"><?php echo e(__("messages.closed")); ?></span></td>
                                                    <?php else: ?>
                                                        <td><a href="<?php echo e($schedule->{"link"}); ?>" target="_blank"><span class="badge bg-gradient-quepal text-white shadow-sm w-100"><?php echo e(__("messages.join")); ?></span></a></td>
                                                    <?php endif; ?>
                                                    <td><?php echo e($schedule->{"studio"}); ?></td>
                                                    <td><?php echo e($schedule->{"start_time"}); ?></td>
                                                    <td><?php echo e($schedule->{"end_time"}); ?></td>
                                                    <td><?php echo e($schedule->{"date"}); ?></td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="<?php echo e(route("revision.edit", $schedule->{"id"})); ?>" class="bx bxs-pencil" title="<?php echo e(__("messages.edit")); ?>"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal" data-revision_id="<?php echo e($schedule->{"id"}); ?>"  data-revision_subject="<?php echo e($schedule->{"subject"}->{"designation"}." (". $schedule->{"exam"}.")"); ?>" title="<?php echo e(__("messages.delete")); ?>"></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <?php echo $__env->make("admin.revision.delete_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script>
        $(document).ready(function () {
            let currentRevisionId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click', '.show-delete-modal', function (e) {
                currentRevisionId = $(this).data('revision_id');
                let revision_subject = $(this).data('revision_subject');
                $("#revision_subject").html(revision_subject);
                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function (event) {
                event.preventDefault();
                if (currentRevisionId !== null) {
                    $.ajax({
                        url: "<?php echo e(route("revision.delete")); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentRevisionId,
                        },
                        beforeSend: function () {
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if (data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>' + data.error + '</b></span>');
                            }
                            if (data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>' + data.success + '</b></span>');
                                window.setTimeout(function () {
                                    window.location.href = "<?php echo e(route("revision.index")); ?>";
                                }, 2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });
        });

        // when sub system dropdown changes
        $('#sub_system').change(function () {
            var subSystemId = $(this).val();
            if (subSystemId) {
                var div_data = "";
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('subject.get-sub-system-subjects')); ?>?sub_system_id=" + subSystemId,
                    success: function (data) {
                        if (data) {
                            $("#subject_id").empty();
                            $("#subject_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                            $.each(data, function (key, value) {
                                var sel = "";
                                if (subject_id === value.id) {
                                    sel = "selected";
                                }
                                $("#subject_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                            });
                        } else {
                            $("#subject_id").empty();
                        }
                    }
                });
            } else {
                $("#subject_id").empty();
            }
        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/select2/js/select2.min.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $('#example').DataTable();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/admin/revision/list.blade.php ENDPATH**/ ?>