@extends("layouts.admin.master")
@section('title',  __('messages.edit_personnel'))

@section("style")
    <link href="{{asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" />
@endsection

@section("wrapper")
    <div class="page-wrapper">
        <div class="page-content">

            @include("admin.response.global")

            <div class="row">
                <div class="col-xl-9 mx-auto">
                    <ol class="breadcrumb mb-0 p-0">
                        <h6 class="mb-0 text-uppercase">{{__("messages.inspectorate") }}</h6>
                    </ol>
                    <hr/>
                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="p-4 border rounded">
                        <form enctype="multipart/form-data" action="{{route("inspectorate.updatePersonnel")}}" method="post" class="row g-4 needs-validation" novalidate>

                            @csrf

                            <input type="hidden" name="id" value="{{$personnel->{"id"} }}">
                            <div class="col-md-4">
                                <label for="validationCustom04" class="form-label">Role</label>
                                <select class="form-select" name="role" id="validationCustom04" required>
                                    <option selected disabled value="">{{__("messages.select")}}</option>
                                    @foreach($inspectorateRoles as $inspectorateRole)
                                        <option value="{{$inspectorateRole->{"name"} }}"
                                        @if($personnel->getRoleNames()[0] == $inspectorateRole->{"name"})
                                            {{"selected"}}
                                            @endif
                                        >{{$inspectorateRole->{"name"} }}</option>
                                    @endforeach

                                </select>
                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom01" class="form-label">First name</label>
                                <input type="text" name="first_name" value="{{$personnel->{"first_name"} }}" class="form-control" id="validationCustom01" required>
                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom02" class="form-label">Last name</label>
                                <input type="text" name="last_name" value="{{$personnel->{"last_name"} }}" class="form-control" id="validationCustom02" required>
                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom04" class="form-label">Gender</label>
                                <select class="form-select" name="gender" id="validationCustom04" required>
                                    <option selected disabled value="">{{__("messages.select")}}</option>
                                    @foreach($genders as $key => $value)
                                        <option value="{{$key}}"
                                        @if($personnel->{"gender"} == $key)
                                            {{"selected"}}
                                            @endif
                                        >{{$value}}</option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom04" class="form-label">Language</label>
                                <select class="form-select" name="locale" name="{{old("locale")}}" id="validationCustom04" required>
                                    <option selected disabled value="">{{__("messages.select")}}</option>
                                    @foreach($languages as $key => $value)
                                        <option value="{{$key}}"
                                        @if($personnel->{"locale"} == $key)
                                            {{"selected"}}
                                        @endif
                                        >{{$value}}</option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom03" class="form-label">Phone number</label>
                                <input type="text" name="phone_number" value="{{$personnel->{"phone_number"} }}" class="form-control" id="validationCustom03" required>
                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom05" class="form-label">New Password</label>
                                <input type="password" name="password" class="form-control" id="validationCustom05" >
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom05" class="form-label">Confirm New Password</label>
                                <input type="password" name="confirm_password" class="form-control" id="validationCustom05" >
                            </div>

                            <div class="col-md-4">
                                <label for="validationCustom05" class="form-label">Profile picture</label>
                                <input type="file" name="profile_picture" class="form-control" id="validationCustom05">
                            </div>

                            <div class="col-12">
                                <button class="btn btn-primary float-end" type="submit">{{__("messages.save")}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

@endsection

@section("script")
    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        } );
    </script>
@endsection
