<?php

return [

    /*
 |--------------------------------------------------------------------------
 | Inspectorates
 |--------------------------------------------------------------------------
 */
    'inspectorates' => [
        'Science' => array(
            "designation" => "Science",
        ),
        'Social sciences' => array(
            "designation" => "Social sciences",
        ),
        'Teacher Training' => array(
            "designation" => "Teacher Training",
        ),
        'Computer Science' => array(
            "designation" => "Computer Science",
        ),
        'Languages' => array(
            "designation" => "Languages",
        ),
        'Industrial Techniques' => array(
            "designation" => "Industrial Techniques",
        ),
        'Technologies and Tertiary Sciences' => array(
            "designation" => "Technologies and Tertiary Sciences",
        ),
        'Guidance and Counselling' => array(
            "designation" => "Guidance and Counselling",
        ),
        'Bilingualism' => array(
            "designation" => "Bilingualism",
        ),
    ],

    /*
|--------------------------------------------------------------------------
| Permissions
|--------------------------------------------------------------------------
*/
    'permission_group' => [
        'Sub system' => array(
            "designation" => "Sub system",
            'permission_category' => array(
                "Sub system" => array(
                    "designation" => "Sub system",
                    'permissions' => array(
                        'Sub system create' => array(
                            "feature" => "Sub system",
                            "name" => "create sub system",
                            "guard_name" => "web",
                        ),
                        'Sub system read' => array(
                            "feature" => "Sub system",
                            "name" => "read sub system",
                            "guard_name" => "web",
                        ),
                        'Sub system edit' => array(
                            "feature" => "Sub system",
                            "name" => "edit sub system",
                            "guard_name" => "web",
                        ),
                        'Sub system delete' => array(
                            "feature" => "Sub system",
                            "name" => "delete sub system",
                            "guard_name" => "web",
                        ),
                    ),
                ),
            ),
        ),
        'Education type' => array(
            "designation" => "Education type",
            'permission_category' => array(
                "Education typ" => array(
                    "designation" => "Education type",
                    'permissions' => array(
                        'Education type create' => array(
                            "feature" => "Education type",
                            "name" => "create education type",
                            "guard_name" => "web",
                        ),
                        'Education type read' => array(
                            "feature" => "Education type",
                            "name" => "read education type",
                            "guard_name" => "web",
                        ),
                        'Education type edit' => array(
                            "feature" => "Education type",
                            "name" => "edit education type",
                            "guard_name" => "web",
                        ),
                        'Education type delete' => array(
                            "feature" => "Education type",
                            "name" => "delete education type",
                            "guard_name" => "web",
                        ),
                    ),
                ),
            ),
        ),
        'Sub education type' => array(
            "designation" => "Sub education type",
            'permission_category' => array(
                "Sub education type" => array(
                    "designation" => "Sub education type",
                    'permissions' => array(
                        'Sub education type create' => array(
                            "feature" => "Sub education",
                            "name" => "create sub education type",
                            "guard_name" => "web",
                        ),
                        'Sub education type read' => array(
                            "feature" => "Sub education",
                            "name" => "read sub education type",
                            "guard_name" => "web",
                        ),
                        'Sub education type edit' => array(
                            "feature" => "Sub education",
                            "name" => "edit sub education type",
                            "guard_name" => "web",
                        ),
                        'Sub education type delete' => array(
                            "feature" => "Sub education",
                            "name" => "delete sub education type",
                            "guard_name" => "web",
                        ),
                    ),
                ),
            ),
        ),

        'Inspectorate' => array(
            "designation" => "Inspectorate",
            'permission_category' => array(
                "Inspectorate" => array(
                    "designation" => "Inspectorate",
                    'permissions' => array(
                            'Inspectorate  create' => array(
                                "feature" => "Inspectorate",
                                "name" => "create inspectorate",
                                "guard_name" => "web",
                            ),
                            'Inspectorate  read' => array(
                                "feature" => "Inspectorate",
                                "name" => "read inspectorate",
                                "guard_name" => "web",
                            ),
                            'Inspectorate  edit' => array(
                                "feature" => "Inspectorate",
                                "name" => "edit inspectorate",
                                "guard_name" => "web",
                            ),
                            'Inspectorate  delete' => array(
                                "feature" => "Inspectorate",
                                "name" => "delete inspectorate",
                                "guard_name" => "web",
                            ),
                    ),

                ),
                'Personnel' => array(
                    'designation' => 'Personnel',
                    'permissions' => array(
                        'Inspectorate personnel create' => array(
                            "feature" => "Inspectorate personnel",
                            "name" => "create inspectorate personnel",
                            "guard_name" => "web",

                        ),
                        'Inspectorate personnel read' => array(
                            "feature" => "Inspectorate personnel",
                            "name" => "read inspectorate personnel",
                            "guard_name" => "web",
                        ),
                        'Inspectorate personnel edit' => array(
                            "feature" => "Inspectorate personnel",
                            "name" => "edit inspectorate personnel",
                            "guard_name" => "web",
                        ),
                        'Inspectorate personnel delete' => array(
                            "feature" => "Inspectorate personnel",
                            "name" => "delete inspectorate personnel",
                            "guard_name" => "web",
                        ),
                    ),
                ),
            ),
        ),

    ],

    /*
|--------------------------------------------------------------------------
| Default roles
|--------------------------------------------------------------------------
*/
    'default_roles' => [
        'Super Admin' => array(
            'role_name' => 'super_admin',
            'name' => 'Super Admin',
            "guard_name" => "web",
            'is_system' => 1,
        ),
        'Admin' => array(
            'role_name' => 'admin',
            'name' => 'Admin',
            "guard_name" => "web",
            'is_system' => 1,
        ),
        'Lesson validator' => array(
            'role_name' => 'lesson_validator',
            'name' => 'Lesson validator',
            "guard_name" => "web",
            'is_system' => 1,
        ),
        'Lesson recorder' => array(
            'role_name' => 'lesson_recorder',
            'name' => 'Lesson recorder',
            "guard_name" => "web",
            'is_system' => 1,
        ),
        'Lesson editor' => array(
            'role_name' => 'lesson_editor',
            'name' => 'Lesson editor',
            "guard_name" => "web",
            'is_system' => 1,
        ),
        'Lesson publisher' => array(
            'role_name' => 'lesson_publisher',
            'name' => 'Lesson publisher',
            "guard_name" => "web",
            'is_system' => 1,
        ),
        'Lesson segmentator' => array(
            'role_name' => 'lesson_segmentor',
            'name' => 'Lesson segmentor',
            "guard_name" => "web",
            'is_system' => 1,
        ),
        'General Inspector Coordinator' => array(
            'role_name' => 'ICG',
            'name' => 'General Inspector Coordinator',
            "guard_name" => "web",
            'is_system' => 0,
        ),
        'Chief of section' => array(
            'role_name' => 'CDS',
            'name' => 'Chief of section',
            "guard_name" => "web",
            'is_system' => 0,
        ),
        'National Pedagogic Inspector' => array(
            'role_name' => 'IPN',
            'name' => 'National Pedagogic Inspector',
            "guard_name" => "web",
            'is_system' => 0,
        ),
        'Regional Inspector Coordinator' => array(
            'role_name' => 'ICR',
            'name' => 'Regional Inspector Coordinator',
            "guard_name" => "web",
            'is_system' => 0,
        ),
        'Regional Pedagogic Inspector' => array(
            'role_name' => 'IPR',
            'name' => 'Regional Pedagogic Inspector',
            "guard_name" => "web",
            'is_system' => 0,
        ),
        'Teacher' => array(
            'role_name' => 'teacher',
            'name' => 'Teacher',
            "guard_name" => "web",
            'is_system' => 0,
        ),
    ],

    /*
|--------------------------------------------------------------------------
| Regions
|--------------------------------------------------------------------------
*/
    'regions' => [
        'Adamawa' => array(
            'designation' => 'Adamawa',
            'divisions' => array(
                array(
                    'designation' => 'Djérem',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Ngaoundal',
                        ),
                        array(
                            'designation' => 'Tibati',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Faro-et-Déo',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Tignère',
                        ),
                        array(
                            'designation' => 'Galim-tignère',
                        ),
                        array(
                            'designation' => 'Mayo-baleo',
                        ),
                        array(
                            'designation' => 'Kontcha',
                        ),

                    ),
                ),
                array(
                    'designation' => 'Mayo-Banyo',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Banyo',
                        ),
                        array(
                            'designation' => 'Bankim',
                        ),
                        array(
                            'designation' => 'Mayo darlé',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mbéré',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Dir',
                        ),
                        array(
                            'designation' => 'Djohong',
                        ),
                        array(
                            'designation' => 'Meiganga',
                        ),
                        array(
                            'designation' => 'Ngaoui',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Vina',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Mbé',
                        ),
                        array(
                            'designation' => 'Martap',
                        ),
                        array(
                            'designation' => 'Nyambaka',
                            array(
                                'designation' => 'Mbelel',
                            ),
                            array(
                                'designation' => 'Nganha',
                                array(
                                    'designation' => 'ngaoundere 1',
                                ),
                                array(
                                    'designation' => 'ngaoundere 2',
                                ),
                                array(
                                    'designation' => 'ngaoundere 3',
                                ),
                            ),
                        ),
                    ),
                ),
            ),
        ),

        'Far North' => array(
            'designation' => 'Far North',
            'divisions' => array(
                array(
                    'designation' => 'Diamaré',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Gazawa',
                        ),
                        array(
                            'designation' => 'Bogo',
                        ),
                        array(
                            'designation' => 'Pette',
                        ),
                        array(
                            'designation' => 'Dargala',
                        ),
                        array(
                            'designation' => 'Ndoukoula',
                        ),
                        array(
                            'designation' => 'Maroua 1er',
                        ),
                        array(
                            'designation' => 'Maroua 2e',
                        ),
                        array(
                            'designation' => 'Maroua 3e',
                        ),
                        array(
                            'designation' => 'Meri',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Logone-et-Chari',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Blangoua',
                        ),
                        array(
                            'designation' => 'Darak',
                        ),
                        array(
                            'designation' => 'Fotokol',
                        ),
                        array(
                            'designation' => 'Goulfey',
                        ),
                        array(
                            'designation' => 'Hile-Halifa',
                        ),
                        array(
                            'designation' => 'Logone-Birni',
                        ),
                        array(
                            'designation' => 'Makary',
                        ),
                        array(
                            'designation' => 'Waza',
                        ),
                        array(
                            'designation' => 'Zina',
                        ),
                        array(
                            'designation' => 'Kousseri',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mayo-Danay',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Gobo',
                        ),
                        array(
                            'designation' => 'Kar-Hay',
                        ),
                        array(
                            'designation' => 'Datcheka',
                        ),
                        array(
                            'designation' => 'Yagoua',
                        ),
                        array(
                            'designation' => 'Guere',
                        ),
                        array(
                            'designation' => 'Maga',
                        ),
                        array(
                            'designation' => 'Kalfou',
                        ),
                        array(
                            'designation' => 'Wina',
                        ),
                        array(
                            'designation' => 'Vele',
                        ),
                        array(
                            'designation' => 'Tchatibali',
                        ),
                        array(
                            'designation' => 'Kai-kai',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mayo-Kani',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Guidiguis',
                        ),
                        array(
                            'designation' => 'Kaele',
                        ),
                        array(
                            'designation' => 'Mindif',
                        ),
                        array(
                            'designation' => 'Moulvoudaye',
                        ),
                        array(
                            'designation' => 'Moutourwa',
                        ),
                        array(
                            'designation' => 'Porhi',
                        ),
                        array(
                            'designation' => 'Taibong',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mayo-Sava',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Kolofata',
                        ),
                        array(
                            'designation' => 'Mora',
                        ),
                        array(
                            'designation' => 'Tokombéré',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mayo-Tsanaga',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Koza',
                        ),
                        array(
                            'designation' => 'Mokolo',
                        ),
                        array(
                            'designation' => 'Bourrha',
                        ),
                        array(
                            'designation' => 'Hina',
                        ),
                        array(
                            'designation' => 'Mogore',
                        ),
                        array(
                            'designation' => 'Mayo-Maskota',
                        ),
                        array(
                            'designation' => 'Soulede-Roua',
                        ),
                    ),
                ),
            ),
        ),

        'North' => array(
            'designation' => 'North',
            'divisions' => array(
                array(
                    'designation' => 'Bénoué',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Baschéo',
                        ),
                        array(
                            'designation' => 'Bibemi',
                        ),
                        array(
                            'designation' => 'Dembo',
                        ),
                        array(
                            'designation' => 'Demsa',
                        ),
                        array(
                            'designation' => 'Garoua 1er,',
                        ),
                        array(
                            'designation' => 'Garoua 2e',
                        ),
                        array(
                            'designation' => 'Garoua 3e',
                        ),
                        array(
                            'designation' => 'Lagdo',
                        ),
                        array(
                            'designation' => 'Mayo-hourna',
                        ),
                        array(
                            'designation' => 'Pitoa',
                        ),
                        array(
                            'designation' => 'Tcheboa',
                        ),
                        array(
                            'designation' => 'Touroua',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Faro',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Poli',
                        ),
                        array(
                            'designation' => 'Beka',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mayo-Louti',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Figuil',
                        ),
                        array(
                            'designation' => 'Guider',
                        ),
                        array(
                            'designation' => 'Mayo-Oulo',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mayo-Rey',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Madingring',
                        ),
                        array(
                            'designation' => 'Rey-bouba',
                        ),
                        array(
                            'designation' => 'Tcholliré',
                        ),
                        array(
                            'designation' => 'Touboro',
                        ),
                    ),
                ),
            ),
        ),

        'Centre' => array(
            'designation' => 'Centre',
            'divisions' => array(
                array(
                    'designation' => 'Haute-Sanaga',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Nanga-Eboko',
                        ),
                        array(
                            'designation' => 'Minta',
                        ),
                        array(
                            'designation' => 'Mbandjok',
                        ),
                        array(
                            'designation' => 'Nkoteng',
                        ),
                        array(
                            'designation' => 'Bibey',
                        ),
                        array(
                            'designation' => 'Nsem',
                        ),
                        array(
                            'designation' => 'Lembe-Yezoum',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Lekié',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Batchenga',
                        ),
                        array(
                            'designation' => 'Ebebda',
                        ),
                        array(
                            'designation' => 'Elig-mfomo',
                        ),
                        array(
                            'designation' => 'Evodoula',
                        ),
                        array(
                            'designation' => 'Lobo',
                        ),
                        array(
                            'designation' => 'Monatélé',
                        ),
                        array(
                            'designation' => 'Obala',
                        ),
                        array(
                            'designation' => 'Okola',
                        ),
                        array(
                            'designation' => "Sa'a",
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mbam-et-Inoubou',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Bafia',
                        ),
                        array(
                            'designation' => 'Deuk',
                        ),
                        array(
                            'designation' => 'Kon-Yambetta',
                        ),
                        array(
                            'designation' => 'Ndikinimeki',
                        ),
                        array(
                            'designation' => 'Ombessa',
                        ),
                        array(
                            'designation' => 'Bokito',
                        ),
                        array(
                            'designation' => 'Makenene',
                        ),
                        array(
                            'designation' => 'Kiiki',
                        ),
                        array(
                            'designation' => 'Nitoukou',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mbam-et-Kim',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Mbangassina',
                        ),
                        array(
                            'designation' => 'Ngambè-tikar',
                        ),
                        array(
                            'designation' => 'Ngoro',
                        ),
                        array(
                            'designation' => 'Ntui',
                        ),
                        array(
                            'designation' => 'Yoko',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Méfou-et-Afamba',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Assamba',
                        ),
                        array(
                            'designation' => 'Edzendouan',
                        ),
                        array(
                            'designation' => 'Mfou',
                        ),
                        array(
                            'designation' => 'Soa',
                        ),
                        array(
                            'designation' => 'Esse',
                        ),
                        array(
                            'designation' => 'Awae',
                        ),
                        array(
                            'designation' => 'Afanloum',
                        ),
                        array(
                            'designation' => 'Nkolafamba',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Méfou-et-Akono',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Akono',
                        ),
                        array(
                            'designation' => 'Bikok',
                        ),
                        array(
                            'designation' => 'Mbankomo',
                        ),
                        array(
                            'designation' => 'Ngoumou',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mfoundi',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Yaounde 1',
                        ),
                        array(
                            'designation' => 'Yaounde 2',
                        ),
                        array(
                            'designation' => 'Yaounde 3',
                        ),
                        array(
                            'designation' => 'Yaounde 4',
                        ),
                        array(
                            'designation' => 'Yaounde 5',
                        ),
                        array(
                            'designation' => 'Yaounde 6',
                        ),
                        array(
                            'designation' => 'Yaounde 7',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Nyong-et-Kéllé',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Biyouha',
                        ),
                        array(
                            'designation' => 'Bot-Makak',
                        ),
                        array(
                            'designation' => 'Bondjock',
                        ),
                        array(
                            'designation' => 'Dibang',
                        ),
                        array(
                            'designation' => 'Eseka',
                        ),
                        array(
                            'designation' => 'Makak',
                        ),
                        array(
                            'designation' => 'Matomb',
                        ),
                        array(
                            'designation' => 'Messondo',
                        ),
                        array(
                            'designation' => 'Ngog-Mapubi',
                        ),
                        array(
                            'designation' => 'Nguibassal',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Nyong-et-Mfoumou',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Akonolinga',
                        ),
                        array(
                            'designation' => 'Endom',
                        ),
                        array(
                            'designation' => 'Ayos',
                        ),
                        array(
                            'designation' => 'Mengang',
                        ),
                        array(
                            'designation' => 'Yakokombo',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Nyong-et-So',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Dzeng',
                        ),
                        array(
                            'designation' => 'Mbalmayo',
                        ),
                        array(
                            'designation' => 'Mengueme',
                        ),
                        array(
                            'designation' => 'Ngomedzap',
                        ),
                        array(
                            'designation' => 'Nkol-Metet',
                        ),
                        array(
                            'designation' => 'Akoeman',
                        ),
                    ),
                ),
            ),
        ),

        'East' => array(
            'designation' => 'East',
            'divisions' => array(
                array(
                    'designation' => 'Boumba-et-Ngoko',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Gari-Gombo',
                        ),
                        array(
                            'designation' => 'Moloundou',
                        ),
                        array(
                            'designation' => 'Salapoumbe',
                        ),
                        array(
                            'designation' => 'Yokadouma',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Haut-Nyong',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Abong-Mbang',
                        ),
                        array(
                            'designation' => 'Bebend',
                        ),
                        array(
                            'designation' => 'Dimako',
                        ),
                        array(
                            'designation' => 'Doumaintang',
                        ),
                        array(
                            'designation' => 'Doumé',
                        ),
                        array(
                            'designation' => 'Lomié',
                        ),
                        array(
                            'designation' => 'Mboanz',
                        ),
                        array(
                            'designation' => 'Mboma',
                        ),
                        array(
                            'designation' => 'Messamena',
                        ),
                        array(
                            'designation' => 'Messok',
                        ),
                        array(
                            'designation' => 'Dja',
                        ),
                        array(
                            'designation' => 'Ngoyla',
                        ),
                        array(
                            'designation' => 'Nguelemendouka',
                        ),
                        array(
                            'designation' => 'Samalomo',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Kadey',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Batouri',
                        ),
                        array(
                            'designation' => 'Kette',
                        ),
                        array(
                            'designation' => 'Mbang',
                        ),
                        array(
                            'designation' => 'Ndelele',
                        ),
                        array(
                            'designation' => 'Ndem-Nam',
                        ),
                        array(
                            'designation' => 'Bombe',
                        ),
                        array(
                            'designation' => 'Mbotoro',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Lom-et-Djerem',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Bélabo',
                        ),
                        array(
                            'designation' => 'Bertoua 1er',
                        ),
                        array(
                            'designation' => 'Bertoua 2e',
                        ),
                        array(
                            'designation' => 'Betaré-oya',
                        ),
                        array(
                            'designation' => 'Diang',
                        ),
                        array(
                            'designation' => 'Garoua-boulai',
                        ),
                        array(
                            'designation' => 'Mandjou',
                        ),
                        array(
                            'designation' => 'Ngoura',
                        ),
                    ),
                ),
            ),
        ),

        'South' => array(
            'designation' => 'South',
            'divisions' => array(
                array(
                    'designation' => 'Dja-et-Lobo',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Bengbis',
                        ),
                        array(
                            'designation' => 'Djoum',
                        ),
                        array(
                            'designation' => 'Meyomessala',
                        ),
                        array(
                            'designation' => 'Mintom',
                        ),
                        array(
                            'designation' => 'Oveng',
                        ),
                        array(
                            'designation' => 'Sangmelima    ',
                        ),
                        array(
                            'designation' => 'Meyomessi',
                        ),
                        array(
                            'designation' => 'Zoetele',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mvila',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Biwong-bane',
                        ),
                        array(
                            'designation' => 'Biwong-bulu',
                        ),
                        array(
                            'designation' => 'Ebolowa 1er',
                        ),
                        array(
                            'designation' => 'Ebolowa 2',
                        ),
                        array(
                            'designation' => 'Efoulan',
                        ),
                        array(
                            'designation' => 'Mengong',
                        ),
                        array(
                            'designation' => 'Mvangan',
                        ),
                        array(
                            'designation' => 'Ngoulemakong',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Océan',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'kribi 1er',
                        ),
                        array(
                            'designation' => 'kribi 2',
                        ),
                        array(
                            'designation' => 'lokoundje',
                        ),
                        array(
                            'designation' => 'Bipindi lolodorf',
                        ),
                        array(
                            'designation' => 'Mvengue',
                        ),
                        array(
                            'designation' => 'Niete',
                        ),
                        array(
                            'designation' => 'Akom 2',
                        ),
                        array(
                            'designation' => 'Niete',
                        ),
                        array(
                            'designation' => 'Campo',
                        ),


                    ),
                ),
                array(
                    'designation' => 'Vallée-du-Ntem"',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Ambam',
                        ),
                        array(
                            'designation' => 'Kye-Ossi',
                        ),
                        array(
                            'designation' => "Ma'an",
                        ),
                        array(
                            'designation' => 'Olamze',
                        ),
                    ),
                ),
            ),
        ),

        'Littoral' => array(
            'designation' => 'Littoral',
            'divisions' => array(
                array(
                    'designation' => 'Moungo',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Baré-bakem',
                        ),
                        array(
                            'designation' => 'Nlonako',
                        ),
                        array(
                            'designation' => 'Dibombari',
                        ),
                        array(
                            'designation' => 'Loum',
                        ),
                        array(
                            'designation' => 'Manjo',
                        ),
                        array(
                            'designation' => 'Mbanga',
                        ),
                        array(
                            'designation' => 'Melong',
                        ),
                        array(
                            'designation' => 'Mombo',
                        ),
                        array(
                            'designation' => 'Njombe penja',
                        ),
                        array(
                            'designation' => 'Nkongsamba 1er',
                        ),
                        array(
                            'designation' => 'Nkongsamba 2e',
                        ),
                        array(
                            'designation' => 'Nkongsamba 3e',
                        ),
                        array(
                            'designation' => 'Fiko',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Nkam',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Yabassi',
                        ),
                        array(
                            'designation' => 'Yingui',
                        ),
                        array(
                            'designation' => 'Nkondjock',
                        ),
                        array(
                            'designation' => 'Nord-makombè',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Sanaga-Maritime',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Dibamba',
                        ),
                        array(
                            'designation' => 'Dizangue',
                        ),
                        array(
                            'designation' => 'Edéa 1er',
                        ),
                        array(
                            'designation' => 'Edéa 2e',
                        ),
                        array(
                            'designation' => 'Massock-song loulou',
                        ),
                        array(
                            'designation' => 'Mouanko',
                        ),
                        array(
                            'designation' => 'Ndom',
                        ),
                        array(
                            'designation' => 'Ngambe',
                        ),
                        array(
                            'designation' => 'pouma',
                        ),
                        array(
                            'designation' => 'Ngwei',
                        ),
                        array(
                            'designation' => 'Nyanon',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Wouri',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Douala 1er',
                        ),
                        array(
                            'designation' => 'Douala 2e',
                        ),
                        array(
                            'designation' => 'Douala 3e',
                        ),
                        array(
                            'designation' => 'Douala 4e',
                        ),
                        array(
                            'designation' => 'Douala 5e',
                        ),
                        array(
                            'designation' => 'Douala 6',
                        ),
                    ),
                ),
            ),
        ),

        'North West' => array(
            'designation' => 'North West',
            'divisions' => array(
                array(
                    'designation' => 'Boyo',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Belo',
                        ),
                        array(
                            'designation' => 'Bum',
                        ),
                        array(
                            'designation' => 'Fundong',
                        ),
                        array(
                            'designation' => 'Njinikom',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Bui',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Djakire',
                        ),
                        array(
                            'designation' => 'Kumbo',
                        ),
                        array(
                            'designation' => 'Mbven',
                        ),
                        array(
                            'designation' => 'Nkum',
                        ),
                        array(
                            'designation' => 'Noni',
                        ),
                        array(
                            'designation' => 'Oku',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Donga-Mantung',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Ako',
                        ),
                        array(
                            'designation' => 'Misaje',
                        ),
                        array(
                            'designation' => 'Ndu',
                        ),
                        array(
                            'designation' => 'Nkambé',
                        ),
                        array(
                            'designation' => 'Nwa',
                        ),

                    ),
                ),
                array(
                    'designation' => 'Menchum',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Menchum valley',
                        ),
                        array(
                            'designation' => 'Furu-awa',
                        ),
                        array(
                            'designation' => 'Wum',
                        ),
                        array(
                            'designation' => 'Fungom',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mezam',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Bafut',
                        ),
                        array(
                            'designation' => 'Bali',
                        ),
                        array(
                            'designation' => 'Bamenda 1er',
                        ),
                        array(
                            'designation' => 'Bamenda 2e',
                        ),
                        array(
                            'designation' => 'Bamenda 3e',
                        ),
                        array(
                            'designation' => 'Santa',
                        ),
                        array(
                            'designation' => 'Tubah',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Momo',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Ngie',
                        ),
                        array(
                            'designation' => 'Batibo',
                        ),
                        array(
                            'designation' => 'Mbengwi',
                        ),
                        array(
                            'designation' => 'Njikwa',
                        ),
                        array(
                            'designation' => 'Widikum-Menka',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Ngo-ketunjia',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Babessi',
                        ),
                        array(
                            'designation' => 'Balikumbat',
                        ),
                        array(
                            'designation' => 'Ndop',
                        ),
                    ),
                ),
            ),
        ),

        'South West' => array(
            'designation' => 'South West',
            'divisions' => array(
                array(
                    'designation' => 'Fako',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Buea',
                        ),
                        array(
                            'designation' => 'Limbe 1er',
                        ),
                        array(
                            'designation' => 'Limbe 2e',
                        ),
                        array(
                            'designation' => 'Limbe 3e',
                        ),
                        array(
                            'designation' => 'Muyuka',
                        ),
                        array(
                            'designation' => 'Tiko',
                        ),
                        array(
                            'designation' => 'West coast',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Koupé-Manengouba',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Bangem',
                        ),
                        array(
                            'designation' => 'Nguti',
                        ),
                        array(
                            'designation' => 'Tombel',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Lebialem',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Alou',
                        ),
                        array(
                            'designation' => 'Fontem',
                        ),
                        array(
                            'designation' => 'Wabane',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Manyu',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Akwaya',
                        ),
                        array(
                            'designation' => 'Eyumodjock',
                        ),
                        array(
                            'designation' => 'Mamfe',
                        ),
                        array(
                            'designation' => 'Upper-Bayang',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Meme',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Koney',
                        ),
                        array(
                            'designation' => 'Kumba 1er',
                        ),
                        array(
                            'designation' => 'Kumba 2e',
                        ),
                        array(
                            'designation' => 'Kumba 3e',
                        ),
                        array(
                            'designation' => 'Bonge',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Ndian',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Bamusso',
                        ),
                        array(
                            'designation' => 'Ekondo-titi',
                        ),
                        array(
                            'designation' => 'Idabato',
                        ),
                        array(
                            'designation' => 'Isanguele',
                        ),
                        array(
                            'designation' => 'Kombo-abedimo',
                        ),
                        array(
                            'designation' => 'Kombo-idinti',
                        ),
                        array(
                            'designation' => 'Mundemba',
                        ),
                        array(
                            'designation' => 'Dikome-Balue',
                        ),
                        array(
                            'designation' => 'Toko',
                        ),
                    ),
                ),
            ),
        ),

        'West' => array(
            'designation' => 'West',
            'divisions' => array(
                array(
                    'designation' => 'Bamboutos',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Babadjou',
                        ),
                        array(
                            'designation' => 'Batcham',
                        ),
                        array(
                            'designation' => 'Galim',
                        ),
                        array(
                            'designation' => 'Mbouda',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Haut-Plateaux"',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Baham',
                        ),
                        array(
                            'designation' => 'Bamendjou',
                        ),
                        array(
                            'designation' => 'Bangou',
                        ),
                        array(
                            'designation' => 'Batie',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Hauts-Nkam',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Bafang',
                        ),
                        array(
                            'designation' => 'Bakou',
                        ),
                        array(
                            'designation' => 'Bana',
                        ),
                        array(
                            'designation' => 'Bandja',
                        ),
                        array(
                            'designation' => 'Banka',
                        ),
                        array(
                            'designation' => 'Kekem',
                        ),
                        array(
                            'designation' => 'Banwa',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Koung-Khi',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Poumougne',
                        ),
                        array(
                            'designation' => 'Bayangam',
                        ),
                        array(
                            'designation' => 'Djebem',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Menoua',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Dschang',
                        ),
                        array(
                            'designation' => 'Fokouè',
                        ),
                        array(
                            'designation' => 'Fongo-tongo',
                        ),
                        array(
                            'designation' => 'Nkong-zem',
                        ),
                        array(
                            'designation' => 'Penka-michel',
                        ),
                        array(
                            'designation' => 'Sanchou',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Mifi',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Bafoussam 1er',
                        ),
                        array(
                            'designation' => 'Bafoussam 2e',
                        ),
                        array(
                            'designation' => 'Bafoussam 3e',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Ndé',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Bagangte',
                        ),
                        array(
                            'designation' => 'Bassamba',
                        ),
                        array(
                            'designation' => 'Bazou',
                        ),
                        array(
                            'designation' => 'Tonga',
                        ),
                    ),
                ),
                array(
                    'designation' => 'Noun',
                    'sub_divisions' => array(
                        array(
                            'designation' => 'Bangourain',
                        ),
                        array(
                            'designation' => 'Foumban',
                        ),
                        array(
                            'designation' => 'Foumbot',
                        ),
                        array(
                            'designation' => 'Kouoptamo',
                        ),
                        array(
                            'designation' => 'Koutaba',
                        ),
                        array(
                            'designation' => 'Magba',
                        ),
                        array(
                            'designation' => 'Malentouen',
                        ),
                        array(
                            'designation' => 'Massangam',
                        ),
                        array(
                            'designation' => 'Njimom',
                        ),
                    ),
                ),
            ),
        ),
    ],

    /*
|--------------------------------------------------------------------------
| Regions
|--------------------------------------------------------------------------
*/
    'default_users' => [
        'Samuel' => array(
            'first_name' => "Samuel",
            'last_name' => "Vukugah",
            'phone_number' => 676307827,
            'locale' => 'en',
            'gender' => 'Male',
            'active'   => 1,
            'verified_at' => now(),
        ),
        'Ajaba' => array(
            'first_name' => "Ajaba Jean",
            'last_name' => "Pierre",
            'phone_number' => 657677316,
            'locale' => 'fr',
            'gender' => 'Male',
            'active' => 1,
            'verified_at' => now(),
        ),
        'Marlène' => array(
            'first_name' => "Djoutieu Tegankong",
            'last_name' => "Marlène Ladouce",
            'phone_number' => 695832769,
            'locale' => 'fr',
            'gender' => 'Female',
            'active'   => 1,
            'verified_at' => now(),
        ),
        'NOAH' => array(
            'first_name' => "NOAH NOAH",
            'last_name' => "Jean Crépin",
            'phone_number' => 657232388,
            'locale' => 'fr',
            'gender' => 'Male',
            'active'   => 1,
            'verified_at' => now(),
        ),
        'kiam ' => array(
            'first_name' => "kiam ",
            'last_name' => "Janvier",
            'phone_number' => 674806824,
            'locale' => 'fr',
            'gender' => 'Male',
            'active'   => 1,
            'verified_at' => now(),
        ),
        'Ulrich' => array(
            'first_name' => "Pieume",
            'last_name' => "Ulrich",
            'phone_number' => 670617958,
            'locale' => 'fr',
            'gender' => 'Male',
            'active'   => 1,
            'verified_at' => now(),
        ),
        'Brice' => array(
            'first_name' => "KOM",
            'last_name' => "Brice",
            'phone_number' => 693552188,
            'locale' => 'fr',
            'gender' => 'Male',
            'active'   => 1,
            'verified_at' => now(),
        ),
        'Sorelle' => array(
            'first_name' => "Nyinang Samary",
            'last_name' => "Oswalde Sorelle",
            'phone_number' => 699931304,
            'locale' => 'fr',
            'gender' => 'Female',
            'active'   => 1,
            'verified_at' => now(),
        ),
        'Armand' => array(
            'first_name' => "Armand",
            'last_name' => "NDOYI",
            'phone_number' => 695255938,
            'locale' => 'en',
            'gender' => 'Male',
            'active'   => 1,
            'verified_at' => now(),
        ),
        'Eric' => array(
            'first_name' => "Sone",
            'last_name' => "Eric",
            'phone_number' => 655747721,
            'locale' => 'en',
            'gender' => 'Male',
            'active'   => 1,
            'verified_at' => now(),
        ),
        'Serge' => array(
            'first_name' => "MANGA",
            'last_name' => "Serge",
            'phone_number' => 679916429,
            'locale' => 'fr',
            'gender' => 'Male',
            'active'   => 1,
            'verified_at' => now(),
        ),
        'Duplex' => array(
            'first_name' => "Duplex",
            'last_name' => "TANE",
            'phone_number' => 675544284,
            'locale' => 'fr',
            'gender' => 'Male',
            'active'   => 1,
            'verified_at' => now(),
        ),
    ],
];
