<?php

namespace App\Services;

use App\Models\Inspectorate;
use Exception;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait InspectorateService
{
    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return Inspectorate::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get all inspectorates
     *
     * @return Builder[]|Collection
     */
    public static function allInspectorates(): Collection|array
    {
        return Inspectorate::query()->get();
    }

    /**
     * Find by id
     *
     * @param int $id
     * @return Builder|Builder[]|Collection|Model|null
     */
    public static function findById(int $id): Model|Collection|Builder|array|null
    {
        return Inspectorate::query()->find($id);
    }

    /**
     * Create inspectorate
     *
     * @param string $designation
     * @return Builder|Model
     */
    public static function createInspectorate(string $designation): Model|Builder
    {
        return self::store(["designation" => $designation]);
    }

    /**
     * Update inspectorate
     *
     * @param int $id
     * @param string $designation
     * @return null
     */
    public static function updateInspectorate(int $id, string $designation)
    {
        try {
            $inspectorate = self::findById($id);
            $updatedInspectorate = $inspectorate->updateService(["designation" => $designation]);

        } catch (Exception $exception) {
            log_debug($exception, "InspectorateService::updateInspectorate");
            $updatedInspectorate = null;
        }

        return $updatedInspectorate;
    }

    /**
     * Delete inspectorate
     *
     * @param int $id
     * @return int|null
     */
    public static function deleteInspectorate(int $id): ?int
    {
        try {
            $inspectorate = Inspectorate::destroy($id);
        } catch (\Exception $exception) {
            log_debug($exception, "InspectorateService::deleteInspectorate");
            $inspectorate = null;
        }

        return $inspectorate;
    }
}
