<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class SubSystemRules
{
    /**
     * create rule
     *
     * @return array
     */

    #[ArrayShape(["designation" => "string", "educationTypeIds" => "string"])] public static function create(): array
    {
        return  [
            "designation" => "required|max:50",
            "educationTypeIds" => "required|array|exists:education_types,id",
        ];
    }

    /** Edit rule
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function edit($id): array
    {
        return [
            "id" => "required|integer|exists:sub_systems",
        ];
    }

    /**
     * Update rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string", "designation" => "string", "educationTypeIds" => "string"])] public static function update(): array
    {
        return [
            "id" => "required|integer|exists:sub_systems",
            "designation" => "required|max:50",
            "educationTypeIds" => "required|array|exists:education_types,id",
        ];
    }

    /**
     *  Delete rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete(): array
    {
        return [
            "id" => "required|integer|exists:sub_systems",
        ];
    }
}
