<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class EducationTypeRules
{

    /**
     * create rule
     *
     * @return array
     */

    #[ArrayShape(["designation" => "string", "subEducationTypeIds" => "string"])] public static function createForTechnical(): array
    {
        return  [
            "designation" => "required|max:50",
            "subEducationTypeIds" => "required|array|exists:sub_education_types,id",
        ];
    }

    #[ArrayShape(["designation" => "string", "classIds" => "string"])] public static function createForGeneral(): array
    {
        return  [
            "designation" => "required|max:50",
            "classIds" => "required|array|exists:classes,id",
        ];
    }

    #[ArrayShape(["designation" => "string", "levelIds" => "string"])] public static function createForTeacherTraining(): array
    {
        return  [
            "designation" => "required|max:50",
            "levelIds" => "required|array|exists:levels,id",
        ];
    }

    /** Edit rule
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function edit($id): array
    {
        return [
            "id" => "required|integer|exists:education_types",
        ];
    }

    /**
     * Update rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string", "designation" => "string", "type" => "string", "subEducationTypeIds" => "string"])] public static function updateForTechnical(): array
    {
        return [
            "id" => "required|integer|exists:education_types",
            "designation" => "required|max:50",
            "type" => "required|max:10",
            "subEducationTypeIds" => "required|array|exists:sub_education_types,id",
        ];
    }


    #[ArrayShape(["id" => "string", "designation" => "string", "type" => "string", "classIds" => "string"])] public static function updateForGeneral(): array
    {
        return [
            "id" => "required|integer|exists:education_types",
            "designation" => "required|max:50",
            "type" => "required|max:10",
            "classIds" => "required|array|exists:classes,id",
        ];
    }

    #[ArrayShape(["id" => "string", "designation" => "string", "type" => "string", "levelIds" => "string"])] public static function updateForTeacherTraining(): array
    {
        return [
            "id" => "required|integer|exists:education_types",
            "designation" => "required|max:50",
            "type" => "required|max:10",
            "levelIds" => "required|array|exists:levels,id",
        ];
    }

    /**
     *  Delete rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete(): array
    {
        return [
            "id" => "required|integer|exists:education_types",
        ];
    }

    /**
     * Get class rule
     *
     * @return array
     */
    #[ArrayShape(["sub_system_id" => "string"])] public static function getEducationTypes(): array
    {
        return [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
        ];
    }
}
