<?php

namespace App\Providers;

use App\Models\Language;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        App::singleton('languages', function(){
            return  Language::allLanguages();
        });

        App::singleton('inspectorateId', function (){
            $user =  auth()->user();
            return $user->{"inspectorate_id"};
        });


        Schema::defaultStringLength(125);
    }
}
