<?php

namespace App\Models;

use App\Services\UserService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes, UserService, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'inspectorate_id',
        'first_name',
        'last_name',
        'phone_number',
        'password',
        'locale',
        'gender',
        'active',
        'verified_at',
        'blocked_at',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [];

    /**
     * Relations functions
     */
    public function inspectorate(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Inspectorate::class);
    }

    /**
     * Admin full name
     *
     * @return string
     */
    public function userName(): string
    {
        return ucwords(
            sprintf(
                "%s %s",
                $this->{'last_name'},
                $this->{'first_name'}
            )
        );
    }


    /**
     * User role
     */
    public function userRole(): string
    {
        return ucwords(sprintf(
                "%s",
                $this->{'role'}
            )
        );
    }
}
